<?php
class nmtk_prosperent_admin {

	var $slug;
	var $settings_link;

	function __construct() {

		$this->slug = str_replace( array( basename( __FILE__ ), '/' ), '', plugin_basename( __FILE__ ) );
		add_action( 'admin_menu', array( &$this, 'admin_menu' ) );
		//add_action( 'admin_notices', array( &$this, 'admin_notices' ) );
	
	}// end func

	function admin_menu() {

		global $nmtk_prosperent;

		// if our top menu already exists, just create sub menu..
		if ( $this->top_menu_exists( 'nmtk-tools' ) ) {
			$pluginpage = add_submenu_page( 'nmtk-tools', $nmtk_prosperent->name.' Settings', $nmtk_prosperent->shortname, 'manage_options', $this->slug, array(&$this, 'settings_page') );
			$this->settings_link = $this->slug;
		}
		// otherwise create top menu..
		else {
			add_menu_page( 'NMTK Tools', 'NMTK Tools', 'manage_options', 'nmtk-tools', array( &$this, 'settings_page' ) );
			$pluginpage = add_submenu_page( 'nmtk-tools', $nmtk_prosperent->name.' Settings', $nmtk_prosperent->shortname, 'manage_options', 'nmtk-tools', array(&$this, 'settings_page') );
			$this->settings_link = 'nmtk-tools';
		}// end if
		
		add_action( "admin_print_scripts-$pluginpage", array( &$this, 'admin_head' ) );	
		add_filter( 'plugin_action_links_' . $nmtk_prosperent->basename, array( &$this, 'settings_link' ) );

	}// end func

	function admin_head() {

		global $nmtk_prosperent;
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'loadjs', $nmtk_prosperent->url . 'admin.js' );
		echo '<link rel="stylesheet" href="' . $nmtk_prosperent->url . 'admin.css" type="text/css" />' . "\n";
	
	}// end func

	function settings_link( $links ) {

		$settings_link = '<a href="admin.php?page=' . $this->settings_link . '">Settings</a>';
		array_unshift( $links, $settings_link );
		return $links;

	}// end func

	function settings_page() {
		
		global $nmtk_prosperent;
		$options = $nmtk_prosperent->get_options();
		
		if ( isset($_POST['update']) ) {
			
			// check user is authorised
			if ( function_exists('current_user_can') && !current_user_can('manage_options') )
				die('Sorry, not allowed...');
			check_admin_referer('nmtk_prosperent_settings');
			$msg = '';

			// check for changed api login details..
			if ( strcmp( $options['api_key'], trim( $_POST['api_key'] ) ) != 0 )
				$options['api_confirmed'] = false;

			$options['api_key'] = trim( $_POST['api_key'] );
			if ( '' == $options['api_key'] ) {
				$msg .= '<p class="alert">Please provide your Prosperent API key!</p>';
				$options['api_confirmed'] = false;
			}

			$options['keyword'] = trim( $_POST['keyword'] );
			if ( '' == $options['keyword'] )
				$msg .= '<p class="alert">Please provide a default keyword phrase for your ads!</p>';

			// check api login..
			if ( !$options['api_confirmed'] && $options['api_key'] && $options['keyword'] ) {
				$result = $this->check_api( $options['api_key'], $options['keyword'] );
				if ( $result === true ) {
					$options['api_confirmed'] = true;
					$msg .= '<p class="success">Successfully connected to the Prosperent API.</p>';
				} else {
					$msg .= '<p class="alert">Prosperent API error: '.$result.'</p>';
				}// end if
			}// end if

			$options['channel_id'] = trim($_POST['channel_id']);
			$options['debug_mode'] = ( isset($_POST['debug_mode']) ) ? true : false;

			$options['use_search_referrer'] = ( isset($_POST['use_search_referrer']) ) ? true : false;
			$options['sort_by'] = $_POST['sort_by'];

			$options['show_search'] = ( isset($_POST['show_search']) ) ? true : false;
			$options['show_sortby'] = ( isset($_POST['show_sortby']) ) ? true : false;
			$options['template'] = $_POST['template'];
			$options['show_title'] = ( isset($_POST['show_title']) ) ? true : false;
			$options['show_image'] = ( isset($_POST['show_image']) ) ? true : false;
			$options['show_description'] = ( isset($_POST['show_description']) ) ? true : false;
			$options['show_price'] = ( isset($_POST['show_price']) ) ? true : false;
			$options['show_sale_price'] = ( isset($_POST['show_sale_price']) ) ? true : false;
			$options['show_details_link'] = ( isset($_POST['show_details_link']) ) ? true : false;
			$options['show_buy_link'] = ( isset($_POST['show_buy_link']) ) ? true : false;
			$options['show_merchant'] = ( isset($_POST['show_merchant']) ) ? true : false;
			$options['max_ads'] = (int) $_POST['max_ads'];
			if ( $options['max_ads'] < 1 || $options['max_ads'] > 500 )
				$msg .= '<p class="alert">Maximum ads should be between <strong>1</strong> and <strong>500</strong>.</p>';
			$options['max_image_size'] = (int) $_POST['max_image_size'];
			$options['show_thumbnails'] = ( isset($_POST['show_thumbnails']) ) ? true : false;
			$options['single_only'] = ( isset($_POST['single_only']) ) ? true : false;
			
			$options['custom_css'] = trim($_POST['custom_css']);
			$options['custom_template'] = trim($_POST['custom_template']);

			$link_cloak_folder = preg_replace( '/\s+/', '-', trim( $_POST['link_cloak_folder'] ) );
			$link_cloak_folder = preg_replace( '/[^a-z0-9\-]/i', '', $link_cloak_folder );
			$options['link_cloak_folder'] = $link_cloak_folder;
			$options['nofollow_links'] = ( isset($_POST['nofollow_links']) ) ? true : false;
			$options['new_window'] = ( isset($_POST['new_window']) ) ? true : false;
			$options['country'] = $_POST['country'];

			if ( isset( $_POST['clear_cache'] ) ) {
				// delete nmtk transients..
				global $wpdb;
				$suppress = $wpdb->suppress_errors();
				$transients = $wpdb->get_col( "SELECT option_name FROM $wpdb->options WHERE option_name LIKE '_transient_nmtk_%'" );
				$wpdb->suppress_errors($suppress);
				for ( $i = 0, $j = count( $transients ); $i < $j; $i++ )
					delete_transient( str_replace( '_transient_', '', $transients[$i] ) );
				$msg .= '<p>The cache has been cleared.</p>';
			}// end if

			update_option('nmtk_prosperent', $options);
			$msg .= '<p><strong>Settings saved.</strong></p>';
			echo '<div id="message" class="updated fade">'.$msg.'</div>';
		
		}// end if

		// output settings form..
		echo '<div class="wrap">'
			. '<h2>'.$nmtk_prosperent->name.' Settings - version '.$nmtk_prosperent->version.'</h2>'
			. '<form method="post">';
		wp_nonce_field('nmtk_prosperent_settings');

		// latest news
		echo '<div class="latestnews">'
			. '<h3>NMTK Latest News</h3>'
			. '<div class="inside">';
		if ( !$options['show_latest_news'] )
			$this->rss_output('http://nichemarketingtoolkit.com/feed/');
		echo '</div>'
			. '<div class="bottom"><a href="http://nichemarketingtoolkit.com/tools/" target="_blank">Click here to see more tools from NMTK</a></div>'
			. '</div>';
		
		echo '<p>You will need an affiliate account with Prosperent before you can display ads and earn commissions using this plugin. Signing up with Prosperent is free, quick and easy. <a href="http://prosperent.com/ref/216655" title="Sign up with Prosperent" target="_blank">Click here to sign up now</a>. <span class="description">Disclaimer: that is a referral link which means Prosperent might reward me for sending you their way (here\'s hoping..)</span>.</p>'
			. '<p>Once you have your Prosperent account you will need an API key, which you can get from your Prosperent affiliate dashboard. When you have your API key, fill in the default information on this page and click the Save Changes button. You are now ready to start displaying Prosperent ads on your pages and posts!</p>'
			. '<p><b>Important:</b> Please take a minute to read the documentation on the <a href="http://nichemarketingtoolkit.com/members/prosperent-wordpress-plugin/" target="_blank">plugin download page</a> on how to get started.</p>'
			. '<p>If you are already familiar with how the plugin works, the <a href="http://nichemarketingtoolkit.com/quick-guides/prosperent.html" target="_blank" onclick="window.open(\'http://nichemarketingtoolkit.com/quick-guides/prosperent.html\', \'popupwindow\', \'resizable=1,scrollbars=1,width=700,height=540\');return false;">quick guide</a> shows basic usage, how to override the default settings, and how to use negative keywords and sorting.</p>'
			. '<hr />';
		
		echo '<h3>API Settings</h3>'
			. '<table class="form-table">'
			. '<tr>'
				. '<th scope="row">Prosperent API key:</th>
					<td><input type="text" name="api_key" id="api_key" value="' . stripslashes( $options['api_key'] ) . '" class="regular-text" style="width:300px;" /> <span class="description">Your Prosperent API key, available from <a href="http://prosperent.com/affiliate/api" target="_blank">http://prosperent.com/affiliate/api</a></span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Default channel id:</th>'
				. '<td><input type="text" name="channel_id" id="channel_id" value="'.stripslashes($options['channel_id']).'" class="regular-text" style="width:160px;" /> <span class="description">A default channel id (optional).</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Debug mode:</th>'
				. '<td><input type="checkbox" id="debug_mode" name="debug_mode"';
					if ( $options['debug_mode'] ) echo 'checked="checked"';
					echo ' /> <span class="description">Will prevent ad impressions and clicks being logged and will display error messages.</span></td>'
			. '</tr>'
			. '</table>'
			. '<p><hr /></p>';
		
		echo '<h3>Ad Topic</h3>'
			. '<table class="form-table">'
			. '<tr>'
				. '<th scope="row">Use search referrer:</th>'
				. '<td><input type="checkbox" id="use_search_referrer" name="use_search_referrer"';
					if ( $options['use_search_referrer'] ) echo 'checked="checked"';
					echo ' /> <span class="description">If the visitor came from a search engine, use their search phrase for the ad topic.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Default keyword:</th>'
				. '<td><input type="text" name="keyword" id="keyword" value="'.stripslashes($options['keyword']).'" class="regular-text" style="width:200px;" /> <span class="description">A default keyword to be used for the ad topic, if no search phrase is found.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Default sorting:</th>'
				. '<td><select name="sort_by" id="sort_by" style="width:170px;">'
					.'<option value="@relevance DESC"';
					if ( $options['sort_by'] == '@relevance DESC' ) echo ' selected="selected"';
					echo '>Relevance: high to low</option>'
					.'<option value="price DESC"';
					if ( $options['sort_by'] == 'price DESC' ) echo ' selected="selected"';
					echo '>Price: high to low</option>'
					.'<option value="price ASC"';
					if ( $options['sort_by'] == 'price ASC' ) echo ' selected="selected"';
					echo '>Price: low to high</option>'
					.'<option value="sales DESC"';
					if ( $options['sort_by'] == 'sales DESC' ) echo ' selected="selected"';
					echo '>No of Sales: high to low</option>'
					.'<option value="sales ASC"';
					if ( $options['sort_by'] == 'sales ASC' ) echo ' selected="selected"';
					echo '>No of Sales: low to high</option>'
					.'</select> <span class="description">A default sort order for the API results.</span></td>'
			. '</tr>'
			. '</table>'
			. '<p><hr /></p>';
		
		echo '<h3>Ad Appearance</h3>'
			. '<table class="form-table">'
			. '<tr>'
				. '<th scope="row">Show search:</th>'
				. '<td><input type="checkbox" id="show_search" name="show_search"';
					if ( $options['show_search'] ) echo 'checked="checked"';
					echo ' /> <span class="description">Display search box above the ads.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Show sortby:</th>'
				. '<td><input type="checkbox" id="show_sortby" name="show_sortby"';
					if ( $options['show_sortby'] ) echo 'checked="checked"';
					echo ' /> <span class="description">Display sort options above the ads.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Ad template:</th>'
				. '<td><select name="template" id="template" style="width:100px;">'
				. '<option value="default"';
					if ( $options['template'] == 'default' ) echo ' selected="selected"';
					echo '>Default</option>'
				. '<option value="classic"';
					if ( $options['template'] == 'classic' ) echo ' selected="selected"';
					echo '>Classic</option>'
				. '<option value="comparison"';
					if ( $options['template'] == 'comparison' ) echo ' selected="selected"';
					echo '>Comparison</option>'
				. '<option value="gallery"';
					if ( $options['template'] == 'gallery' ) echo ' selected="selected"';
					echo '>Gallery</option>'
				. '<option value="custom"';
					if ( $options['template'] == 'custom' ) echo ' selected="selected"';
					echo '>Custom</option>'
					. '</select> <span class="description">The default layout of the ads.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Ad elements:</th>'
				. '<td><div style="padding-top:0.2em;"><span class="description"><a href="javascript:void(0);" id="ad-elements">Click here to show/hide ad elements</a></span></div>'
				. '<div id="ad-elements-inside" style="display:none;"><input type="checkbox" id="show_title" name="show_title"';
					if ( $options['show_title'] ) echo 'checked="checked"';
					echo ' /> Title<br />'
					. '<input type="checkbox" id="show_image" name="show_image"';
					if ( $options['show_image'] ) echo 'checked="checked"';
					echo ' /> Image<br />'
					. '<input type="checkbox" id="show_description" name="show_description"';
					if ( $options['show_description'] ) echo 'checked="checked"';
					echo ' /> Description<br />'
					. '<input type="checkbox" id="show_price" name="show_price"';
					if ( $options['show_price'] ) echo 'checked="checked"';
					echo ' /> Price<br />'
					. '<input type="checkbox" id="show_sale_price" name="show_sale_price"';
					if ( $options['show_sale_price'] ) echo 'checked="checked"';
					echo ' /> Sale Price<br />'
					. '<input type="checkbox" id="show_details_link" name="show_details_link"';
					if ( $options['show_details_link'] ) echo 'checked="checked"';
					echo ' /> View Details<br />'
					. '<input type="checkbox" id="show_buy_link" name="show_buy_link"';
					if ( $options['show_buy_link'] ) echo 'checked="checked"';
					echo ' /> Buy Now<br />'
					. '<input type="checkbox" id="show_merchant" name="show_merchant"';
					if ( $options['show_merchant'] ) echo 'checked="checked"';
					echo ' /> Merchant</div></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Maximum ads:</th>'
				. '<td><input type="text" name="max_ads" id="max_ads" value="'.$options['max_ads'].'" class="small-text" /> <span class="description">The maximum number of ads to show at once (no more than 500).</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Maximum image size:</th>'
				. '<td><input type="text" name="max_image_size" id="max_image_size" value="'.$options['max_image_size'].'" class="small-text" /> <span class="description">The maximum width or height of ad images (in pixels).</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Show thumbnails:</th>'
				. '<td><input type="checkbox" id="show_thumbnails" name="show_thumbnails"';
					if ( $options['show_thumbnails'] ) echo 'checked="checked"';
					echo ' /> <span class="description">Show thumbnails (when available) instead of full size images.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Single posts &amp; pages only:</th>'
				. '<td><input type="checkbox" id="single_only" name="single_only"';
					if ( $options['single_only'] ) echo 'checked="checked"';
					echo ' /> <span class="description">Only display ads on single posts and pages?</span></td>'
			. '</tr>'
			. '</table>'
			. '<p><hr /></p>';
		
		echo '<h3>Ad Customization</h3>'
			. '<table class="form-table" style="width:99%;">'
			. '<tr>'
				. '<th scope="row">Custom CSS code:</th>'
				. '<td><span class="description">You can provide custom CSS code here, which will override the default CSS.</span><br /><textarea name="custom_css" id="custom_css" class="large-text code">'.stripslashes($options['custom_css']).'</textarea></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Custom template code:</th>'
				. '<td><span class="description">Please see the documentation on the plugin download page for an explanation of custom templates.</span><br /><textarea name="custom_template" id="custom_template" class="large-text code">'.stripslashes($options['custom_template']).'</textarea></td>'
			. '</tr>'
			. '</table>'
			. '<p><hr /></p>';
		
		echo '<h3>Advanced Settings</h3>'
			. '<table class="form-table">'
			. '<tr>'
				. '<th scope="row">Link cloak folder:</th>'
				. '<td><code>' . get_bloginfo( 'url' ) . '/<input type="text" name="link_cloak_folder" id="link_cloak_folder" value="' . $options['link_cloak_folder'] . '" class="regular-text code" style="width:80px;" />/</code> <span class="description">A virtual (non-existent) folder for your cloaked links (optional).</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Country:</th>'
				. '<td><select name="country" id="country" style="width:120px;">'
				. '<option value="auto"';
					if ( $options['country'] == 'auto' ) echo ' selected="selected"';
					echo '>Auto detect</option>'
				. '<option value="CA"';
					if ( $options['country'] == 'CA' ) echo ' selected="selected"';
					echo '>Canada</option>'
				. '<option value="FR"';
					if ( $options['country'] == 'FR' ) echo ' selected="selected"';
					echo '>France</option>'
				. '<option value="DE"';
					if ( $options['country'] == 'DE' ) echo ' selected="selected"';
					echo '>Germany</option>'
				. '<option value="UK"';
					if ( $options['country'] == 'UK' ) echo ' selected="selected"';
					echo '>United Kingdom</option>'
				. '<option value="US"';
					if ( $options['country'] == 'US' ) echo ' selected="selected"';
					echo '>United States</option>'
					. '</select> <span class="description">Choose to display ads for a specific country or auto-detect the visitor\'s country.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Nofollow links:</th>'
				. '<td><input type="checkbox" id="nofollow_links" name="nofollow_links"';
					if ( $options['nofollow_links'] ) echo 'checked="checked"';
					echo ' /> <span class="description">Tick this box to add "rel=nofollow" to your affiliate links.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Open links in new window:</th>'
				. '<td><input type="checkbox" id="new_window" name="new_window"';
					if ( $options['new_window'] ) echo 'checked="checked"';
					echo ' /> <span class="description">Tick this box to make your affiliate links open in a new window.</span></td>'
			. '</tr>'
			. '<tr>'
				. '<th scope="row">Clear the cache:</th>'
				. '<td><input type="checkbox" id="clear_cache" name="clear_cache" /> <span class="description">Tick this box and click the Save Changes button to clear the cache.</span></td>'
			. '</tr>'
			. '</table>'
			. '<p class="submit"><input type="submit" name="update" class="button-primary" value="Save Changes" /></p>'
			. '</form>'
			. '</div>';
		
	}// end func

	function check_api( $api_key, $keyword ) {
		$keyword = urlencode( $keyword );
		$url = "http://api.prosperent.com/api/search?api_key=$api_key&query=$keyword&visitor_ip=127.0.0.1&debugMode=true";
		$response = wp_remote_fopen( $url );
		if ( $response ) {
			if ( false !== strpos( $response, 'errors' ) ) {
				$json = json_decode( $response, $array = true );
				if ( $json['errors'] ) {
					return $json['errors'][0]['msg'];
				}
				else {
					if ( $json['countryCode'] ) {
						$products = $json['data'];
						if ( is_array( $products ) && count( $products ) ) {
							$transient_key = 'nmtk_' . $json['countryCode'] . '_' . sanitize_file_name( $keyword );
							set_transient( $transient_key, $products, 86400 );
						}// end if
					}// end if
					return true;
				}// end if
			}
			else
				return 'Unable to decode JSON response.';
		}
		else
			return 'Unable to login to Prosperent server.';
	}// end func

	function top_menu_exists( $slug ) {
		if ( '' != $slug ) {
			global $menu;
			foreach ( $menu as $menu_item ) {
				if ( $slug == $menu_item[2] )
				return true;
			}// end if
		}// end if
		return false;
	}// end func

	function admin_notices() {
		global $nmtk_prosperent;
		$this_version = $nmtk_prosperent->version;
		$latest_version = '2.8.2';
		if ( version_compare( $this_version, $latest_version, '<' ) ) {
			$msg = __( "Version $latest_version of the Prosperent plugin is available. Please <a href='http://nichemarketingtoolkit.com/members/prosperent-wordpress-plugin/' target='_blank'>download</a> the latest version." );
			echo "<div class='update-nag'>$msg</div>";
		}
	}// end func

	function rss_output( $url, $args = array() ) {
		$rss = fetch_feed( $url );

		if ( is_wp_error( $rss ) ) {
			if ( is_admin() || current_user_can( 'manage_options' ) )
				echo '<p>' . sprintf( __('<strong>RSS Error</strong>: %s'), $rss->get_error_message() ) . '</p>';
			return;
		}

		$default_args = array( 'show_author' => 0, 'show_date' => 0, 'show_summary' => 0 );
		$args = wp_parse_args( $args, $default_args );
		extract( $args, EXTR_SKIP );

		$items = (int) $items;
		if ( $items < 1 || 20 < $items )
			$items = 10;
		$show_summary  = (int) $show_summary;
		$show_author   = (int) $show_author;
		$show_date     = (int) $show_date;

		if ( !$rss->get_item_quantity() ) {
			echo '<p>' . __( 'An error has occurred. We will try again later.' ) . '</p>';
			$rss->__destruct();
			unset($rss);
			return;
		}

		echo '<ul>';
		foreach ( $rss->get_items(0, $items) as $item ) {
			$link = $item->get_link();
			while ( stristr($link, 'http') != $link )
				$link = substr($link, 1);
			$link = esc_url(strip_tags($link));
			$title = esc_attr(strip_tags($item->get_title()));
			if ( empty($title) )
				$title = __('Untitled');

			$desc = str_replace( array("\n", "\r"), ' ', esc_attr( strip_tags( @html_entity_decode( $item->get_description(), ENT_QUOTES, get_option('blog_charset') ) ) ) );
			$desc = wp_html_excerpt( $desc, 360 );

			// Append ellipsis. Change existing [...] to [&hellip;].
			if ( '[...]' == substr( $desc, -5 ) )
				$desc = substr( $desc, 0, -5 ) . '[&hellip;]';
			elseif ( '[&hellip;]' != substr( $desc, -10 ) )
				$desc .= ' [&hellip;]';

			$desc = esc_html( $desc );

			if ( $show_summary ) {
				$summary = "<div class='rssSummary'>$desc</div>";
			}
			else {
				$summary = '';
			}

			$date = '';
			if ( $show_date ) {
				$date = $item->get_date();

				if ( $date ) {
					if ( $date_stamp = strtotime( $date ) )
						$date = ' <span class="rss-date">' . date_i18n( get_option( 'date_format' ), $date_stamp ) . '</span>';
					else
						$date = '';
				}
			}

			$author = '';
			if ( $show_author ) {
				$author = $item->get_author();
				if ( is_object($author) ) {
					$author = $author->get_name();
					$author = ' <cite>' . esc_html( strip_tags( $author ) ) . '</cite>';
				}
			}

			if ( $link == '' ) {
				echo "<li>$title{$date}{$summary}{$author}</li>";
			}
			else {
				echo "<li><a class='rsswidget' href='$link' title='$desc'>$title</a>{$date}{$summary}{$author}</li>";
			}
		}
		echo '</ul>';
		$rss->__destruct();
		unset($rss);
	}// end func

}// end class
$nmtk_prosperent_admin = new nmtk_prosperent_admin;
