<?php



/*

* String functions

*

* Web Traffic Genius Pro v3.5.4

* Copyright (c) 2008-2010

* Success on the Internet Pty Ltd

* PO Box 25

* Salisbury SA 5108

* Australia

* Phone: +61 422 512 549

* Fax: +61 8 8425 9657

* Web: http://www.webtrafficgenius.com

* Support: http://www.marketing-assassins.com

*

*/



function wtg_get_string_between_sub($search, $from, $start_pos, &$pos1, &$search1, $case_sensitive) {

	if ( !is_array($search) ) $search = array($search);



	$pos1_curr    = false;

	$search1_curr = '';

	$pos1         = false;

	$search1      = '';

	foreach( $search as $search1_curr ) {

		$pos1_curr = call_user_func( $case_sensitive ? 'strpos' : 'stripos', $from, $search1_curr, $start_pos );

		if ( $pos1_curr === false ) {

			continue;

		} else if ( $pos1 === false or $pos1_curr < $pos1 ) {

			$pos1    = $pos1_curr;

			$search1 = $search1_curr;

		}

	}

}



// If you pass an array to this function in the 2 first arguments,

//  it'll try to find out the minimal position of those 2...

function wtg_get_string_between($s1_arr, $s2_arr, $from, &$start_pos, $case_sensitive = false, $including_outsides = false, $stop_if_not_found = true, $add_search2_length = true) {

	wtg_get_string_between_sub($s1_arr, $from, $start_pos, $pos1, $search1, $case_sensitive);

	wtg_get_string_between_sub($s2_arr, $from, $pos1 === false ? $start_pos : $pos1 + strlen($search1), $pos2, $search2, $case_sensitive);



	if ( $pos1 !== false ) {

		if ( !$including_outsides )

		$pos1 += strlen($search1);

	} else if ( $stop_if_not_found ) {

		$start_pos = strlen($from);

		return '';

	} else {

		$pos1 = $start_pos;

	}



	if ( $pos2 !== false ) {

		if ( $add_search2_length )

			$start_pos = $pos2 + strlen($search2);

		if ( $including_outsides )

			$pos2 += strlen($search2);

	} else if ( $stop_if_not_found ) {

		$start_pos = strlen($from);  // top1 r-p-p

		return '';

	} else {

		$start_pos = strlen($from);

		$pos2 = strlen($from);

	}

	return substr( $from, $pos1, $pos2 - $pos1 );

}



function wtg_is_space( $c ) {

	settype($c, 'string');

	return in_array($c{0}, array(" ", "\t", "\r", "\n"));

}



function wtg_compare_by_name($x, $y) {

    if ( strtolower($x['name']) == strtolower($y['name']) )

        return 0;

    else if ( strtolower($x['name']) < strtolower($y['name']) )

        return -1;

    else

        return 1;

}



function wtg_compare_by_title($x, $y) {

    if ( strtolower($x['title']) == strtolower($y['title']) )

        return 0;

    else if ( strtolower($x['title']) < strtolower($y['title']) )

        return -1;

    else

        return 1;

}