<?php
/*
* Register for Web Traffic Genius Plugin
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');

function wtg_register_plugin() {
	$wtg_option = get_option('wtg_option');
	if (isset($_POST['register'])) {
		$message=wtg_register();
	}
	$result=wtg_get_version(WTG_UPGRADE_VERSION_URL);
	if(version_compare($result, WTG_CURRENT_VERSION, '>')) {
		echo '<br><div class="error"><p>BETA version.</p></div>';
		echo '<div class="error"><p>An upgrade v'.$result.' is available for download.</p></div>';
	}
?>
<div class="wrap">
	<h2>Register Web Traffic Genius on this page.</h2>
	<p>This screen is just to register the Web Traffic Genius Plugin. The feed only can be submitted after the successful registeration.</p>
<?php
	if($wtg_option['registration']) {
		echo '<div class="error fade below-h2" id="message"><p>You have already registered. You do not need to register again.</p></div>';
	} else {
		if($message['message']) {
			if($message['type'] == 'register') {
				$class="updated fade";
			} else {
				$class="error fade below-h2";
			}
			print '<div class="'.$class.'" id="message"><p>'.$message['message'].'</p></div>';
		}
	}
?>	
	<table width="100%">
	<tr>
		<td>
			<form action="" method="post">
			<div class="wrap">
			<table class="form-table">
			<tr valign="top">
				<th scope="row"><label for="tmp_folder">Receipt Number</label></th>
				<td><input type="text" size="40" value="<?php echo (isset($_POST['receipt_num']))?$_POST['receipt_num']:''?>" id="receipt_num" name="receipt_num"  <?php if($wtg_option['registration']) {
					echo 'readonly="readonly"';
				}?>>
				<br><span class="description">&nbsp;Please enter your receipt number.</span>
				</td>
			</tr>
			</table>
			<p class="submit">
				<input type="submit" name="register" value="Register &raquo;" />
			</p>
			<p>To obtain a licensed copy of web traffic genius, <a href="http://www.webtrafficgenius.com/traffic.html" target="_blank">click here</a></p>
			</form>
		</td>
	</tr>
	</table>
<?php
}
function wtg_register() {
	$wtg_option = get_option('wtg_option');
	
	if($_POST['receipt_num']) {
		if($wtg_option['registration'] && $wtg_option['receipt_number']) {
			$data['message']='You have already registered. You do not need to register again.';
		} else {
		
			//$url='http://webtrafficgenius.com/upgrade/wtg-activations-stats-test.php';
			$message=wtg_post_data(WTG_CHECK_URL, array("receipt_num" => $_POST['receipt_num'], "domain" => $_SERVER['SERVER_NAME'], "ipaddress" => $_SERVER['REMOTE_ADDR'], "type" => 'wtg'));
			
			$pos = strpos($message, 'uncomplete');
			if($pos === false) {
				$wtg_option['registration']= 1;
				// get current registration date
				
				// encoded the receipt number and domain
				$_SERVER['SERVER_NAME']=convert_uuencode($_SERVER['SERVER_NAME']);
				$_POST['receipt_num']=convert_uuencode($_POST['receipt_num']);
				$wtg_option['receipt_number']= $_POST['receipt_num'];				
				$wtg_option['domain']= $_SERVER['SERVER_NAME'];
				$wtg_option['registration_date']= convert_uuencode(date("Y-m-d h:i:s"));
				$random_number=rand(3,7);
				$wtg_option['time_interval']=$random_number;
				$data['message']='Registration was successful.';
				$data['type']='register';
				// decode receipt number again to display in textbox
				$_POST['receipt_num']=convert_uudecode($_POST['receipt_num']);
			} else {
				$wtg_option['registration']=0;
				$wtg_option['receipt_number']='';
				$wtg_option['domain']='';
				$wtg_option['registration_date']=convert_uuencode(date("Y-m-d h:i:s"));
				$random_number=rand(3,7);
				$wtg_option['time_interval']=$random_number;
				$data['message']='Registration was not successful. Returned: '.$message;
			}
			update_option('wtg_option', $wtg_option);
		}
	} else {
		$data['message']='Please enter the receipt number.';
	}
	return $data;
}



?>