<?php
/*
* Extra feed class
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/php5_functions.php');
require_once(dirname(__FILE__) . '/simplexml.php');

if(!class_exists('WTG_Extrafeed')):

class WTG_Extrafeed {

	var $dom;
	var $simple_xml;
	var $extrafeeds;
	
	function initDB() {
		global $wpdb;
		$table_name_extrafeeds = $wpdb->prefix . "_wtg_extrafeeds";
		$this->extrafeeds = $wpdb->get_results( "SELECT * FROM ".$table_name_extrafeeds." ORDER BY `title` ASC " );
	}
	
	function get_all_extrafeedsDB() {
		return $this->extrafeeds;
	}
	
	function get_extrafeedDB($id) {
		foreach ($this->get_all_extrafeedsDB() as $extrafeed) {
			if (strcmp($extrafeed->id, $id) == 0) {
				return $extrafeed;
			}
		}
		return false;
	}
	
	function set_extrafeed_paramsDB($id, $title,$url,$desc) {
		global $wpdb;
		$table_name_extrafeeds = $wpdb->prefix . "_wtg_extrafeeds";
		foreach ($this->get_all_extrafeedsDB() as $extrafeed) {
			if ($extrafeed->id == $id) {
				$extrafeed->title = trim($title);
                $extrafeed->url = trim($url);
				$extrafeed->desc = trim($desc);
				
				$wpdb->update( $table_name_extrafeeds , array( 'title' => trim($title), 'url' => trim($url), 'desc' => trim($desc) ), array( 'id' => $id ));

				return;
			}
		}
		return false;
	}
	
	function delete_extrafeedDB($id) {
		global $wpdb;
		$table_name_extrafeeds = $wpdb->prefix . "_wtg_extrafeeds";
		foreach ($this->get_all_extrafeedsDB() as $extrafeed) {
			if ($extrafeed->id == $id) {
				unset($extrafeed);

				$wpdb->query("DELETE FROM ".$table_name_extrafeeds." WHERE id=".$id.";");
				return;
			}
		}
		return false;
	}
	
	function add_extrafeedDB($title,$url,$desc) {
		global $wpdb;
		$table_name_extrafeeds = $wpdb->prefix . "_wtg_extrafeeds";
		//$id = strtoupper(substr(md5(strval(time())), 0, 5));
		$id = strtoupper(substr(md5(uniqid(time())), 0, 5));
		$extrafeed = array();
		$extrafeed['id'] = $id;
		$extrafeed['title'] = trim($title);
		$extrafeed['url']= trim($url);
		$extrafeed['desc']= trim($desc);
		$this->extrafeed[] = $extrafeed;
		
		$wpdb->insert( $table_name_extrafeeds, array( 'title' => $title, 'url' => $url, 'desc' => $desc ) );
		return;
		//return $this->_update() ? $id : false;
	}
	
	function wtg_parse_extrafeed_xml($extrafeed_xml) {
		$this->simple_xml = new MySimpleXML();
		return $this->simple_xml->xml_load_string($extrafeed_xml, 'array');
	}
	
	function get_db2xml() 
	{
		$feed_content = '';
		ob_start();?><?php echo '<?xml version="1.0" encoding="'.get_option('blog_charset').'"?'.'>'; ?>
<root>
<?php
$ef = new WTG_Extrafeed();
$ef->initDB();
$extrafeeds_list = $ef->get_all_extrafeedsDB();
if (is_array($extrafeeds_list) && !empty($extrafeeds_list)) 
{
	foreach ($extrafeeds_list as $extrafeed)
	{
		?>
	<extrafeed>
		<id><?php echo htmlspecialchars($extrafeed->id); ?></id>
		<title><?php echo htmlspecialchars($extrafeed->title); ?></title>
		<url><?php echo htmlspecialchars($extrafeed->url); ?></url>
		<desc><?php echo htmlspecialchars($extrafeed->desc); ?></desc>
	</extrafeed>
		<?php
	}
}
?>
</root>
<?php
		$feed_content = ob_get_contents();
		ob_end_clean();
		$wtg_option = get_option('wtg_option');
		
		if(wtg_path_is_absolute($wtg_option['feedDir'])) {
			$feed_absdir = $wtg_option['feedDir'] . '/';
		} else {
			$feed_absdir = wtg_detect_doc_root() . '/' . $wtg_option['feedDir'] . '/';
		}
	
		$feed_name = "extrafeeds_backup.xml";
	
		file_put_contents($feed_absdir . $feed_name, $feed_content);

		return file_get_contents($feed_absdir . $feed_name);
	}
	//////////////////////////////////////////////////////

	function init() {
		$extrafeed_xml = file_get_contents(EXTRAFEED_XML);
		if (empty($extrafeed_xml)) return false;
		$quotes = array( 
   '&#8216;' => "'", 
   '&#8217;' => "'", 
   '&#8220;' => '"', 
   '&#8221;' => '"' 
		);
		$extrafeed_xml=str_replace(array_keys($quotes), $quotes, $extrafeed_xml);
		$extrafeed_xml=stripcslashes($extrafeed_xml);

		$this->dom = $this->_parse_extrafeed_xml($extrafeed_xml);

		return true;
	}

	function get_all_extrafeeds() {
		return wtg_to_array($this->dom['extrafeed']);
	}

	function get_xml() {
		return file_get_contents(EXTRAFEED_XML);
	}

	function get_extrafeed($id) {
		foreach ($this->get_all_extrafeeds() as $extrafeed) {
			if (strcmp($extrafeed['id'], $id) == 0) {
				return $extrafeed;
			}
		}
		return false;
	}

	function _update() {
		$extrafeed_xml = $this->simple_xml->asXML($this->dom);
		return file_put_contents(EXTRAFEED_XML, $extrafeed_xml);
	}

	function add_extrafeed($title,$url,$desc) {
		//$id = strtoupper(substr(md5(strval(time())), 0, 5));
		$id = strtoupper(substr(md5(uniqid(time())), 0, 5));
		$extrafeed = array();
		$extrafeed['id'] = $id;
		$extrafeed['title'] = trim($title);
		$extrafeed['url']= trim($url);
		$extrafeed['desc']= trim($desc);
		$this->dom['extrafeed'][] = $extrafeed;
		return $this->_update() ? $id : false;
	}

	function set_extrafeed_params($id, $title,$url,$desc) {
		foreach (wtg_to_array($this->dom['extrafeed']) as $k => $extrafeed) {
			if ($extrafeed['id'] == $id) {
				$this->dom['extrafeed'][$k]['title'] = trim($title);
                $this->dom['extrafeed'][$k]['url'] = trim($url);
				$this->dom['extrafeed'][$k]['desc'] = trim($desc);
				return $this->_update();
			}
		}
		return false;
	}

	function delete_extrafeed($id) {
		foreach (wtg_to_array($this->dom['extrafeed']) as $k => $extrafeed) {
			if ($extrafeed['id'] == $id) {
				unset($this->dom['extrafeed'][$k]);
				return $this->_update();
			}
		}
		return false;
	}
}
endif;