<?php
  $tooltips = array(


    "schedule" => "<p>Set how often CommentPiG Pro adds new comments to your blog posts. Enter either a single digit or a range (e.g. 5-10) from which CommentPiG Pro will choose a random value each time it runs.</p><p>In addition you can limit the maximum age of posts that are commented on. This is useful if you would like to concentrate your comment posting onto your blog's most recent posts. If this is not checked CommentPiG Pro will randomly choose a post from the entire post archive to comment on. This technique works well for maintaining search engine interest in old posts.</p>",


    "category" => "<p>You can also limit the post categories from which the post is chosen. Check all the categories you want to skip when adding comments.</p>",


    "target" => "<p>Post tags - CommentPiG Pro will search for comments using a random tag from your post. If you are not already using tags please try TagPiG, our automated tagging plugin for WordPress.</p><p>Post title - CommentPiG Pro will search for comments using the post title. This setting is only recommended if you are using simple keyword based titles (e.g. Moulin Rouge) anything more complicated will yield very low matches.</p><p>Post custom field - CommentPiG Pro can also search for comments using a value taken from a custom field in your post. Simply enter the name of the custom field in the box and CommentPiG Pro will do the rest. Custom Fields are an advanced WordPress feature allowing you to store extra metadata with your blog posts.</p><p>Random - (Advanced) CommentPiG Pro will choose a random comment from your local comment database.</p>",


    "status" => "<p>You can choose whether the comments that CommentPiG Pro creates are instantly displayed on your blog posts or held in the WordPress admin area for manual approval later. I recommend setting it to Approved.</p>",


    "retry" => "<p>The number of times CommentPiG will retry if it fails to find a comment on any paticular cycle</p>",


    "comments" => "<p>8 comment sources provide targeted comments for your blog posts. The weight parameter can be used if more than one source has been selected. The higher the weight the more often that source will be used.</p><p>YouTube Tags - Searches for videos sharing your post keyword and then chooses a random comment from the video to add to your post. Provides short generic comments giving your blog a very natural community feel.</p><p>YouTube Comments - Searches for specific comments containing your post keyword. Comments will always contain your keyword.</p><p>Twitter - Comments will always contain keyword variations from your posts.</p><p>Backtype - Comments are gathered from many different sources. Highly targeted and will always contain keyword variations from your posts.</p><p>FreindFeed comments will often be highly targeted and will always contain post keywords. Sometimes very large, use filters.</p><p>Yahoo Answers - Searches for questions containing your post keyword, a random answer is then chosen and added to your blog. Very targeted comments but may not contain exact matching keywords from your post. You should obtain your own free Yahoo AppID.</p><p>Wordpress.com - Highly targeted. Comments always contain post keyword variations.</p><p>Local DB - Advanced users can upload their own custom comment DB. Comment extraction tools are available in the BlogPig Members' Area to build your own comment DB.</p>",


    "names" => "<p>Each new comment requires a username.If more then one is selected CommentPiG will choose randomly.</p><p>Comment Sources - Names is randomly selected from all those displayed at the comment source.</p><p>BlogPiG Random API - The perfect way to guarantee 100% unique names is to leverage the BlogPiG API to pull a new name for each of your comments. At BlogPiG.com we maintain a massive database of potential usernames and when these are combined with our unique markov algorithm we can absolutely guarantee uniqueness every time.</p><p>Local DB - Advanced users can also upload their own username database. This opens up a good opportunity to inject more themed keywords into your blog post entries.</p>",


    "keyword in comment" => "<p>Checking this box will cause the plugin to publish only comments which contain the target keyword</p><p>NOTE: Using some comment sources with this option might result in a much lower success ratio</p>",


    "comment size" => "<p>Choose the maximum & minimum size for your comments.</p><p>Any comments that fall outside of these criteria will either be cropped or skipped depending on which option you choose</p>",


    "word filter" => "<p>Comments containing any of these words will not be published</p><p>One word per line</p>",


    "account filter" => "<p>Comments comming from any of these accounts/users will not be published</p><p>One account/username per line</p>",


    "strip links" => "<p>Checking this box will cause all HTML links to be stripped from the retrieved comments</p>",


    "upload comments" => "<p>CommentPiG works extremely well when running on autopilot but some advanced users may wish to leverage the powerful Local Database options. It takes a bit of extra preparation time but it can produce very beneficial results.In order to fully use the Local Database options you will need to be able to harvest your own comments and usernames.</p><p>We've produced a range of desktop applications that can help you harvest suitable comments. You can then use a bulk search & replace tool or text manipulation tool to clean them ready for your blog.</p><p>Click Append to add the comments to your database. If you already have comments in your local DB the new upload will be appended to the existing list.</p><p>If you want the new comments to replace the existing comments simply click Clear DB before uploading the new comments.</p><p>Total/Used - This shows the number of comments already in your Local DB and the number of comments that have already been used. This is only relevant if 'don't reuse local comments' was checked earlier. You can view your uploaded comments by clicking on the view link and you can reset the used count by clicking the reset link.</p>",


    "upload names" => "<p>To upload a new local name database just Browse to the CSV file on your computer.</p><p>Click the Append button, if you already have names in your local database the new upload will be appended to the existing list.</p><p>If you want the new names to replace the existing comments simply click Clear DB before uploading the new names.</p><p>Total - The number of names in your Local DB is shown here and you can view them individually by clicking on the view link.</p><p>As with comments you will need to create a CSV to import your usernames into CommentPiG Pro. The usernames spreadsheet is simply a single column containing all the names you wish to import, one per line. There are no additional columns allowed.</p>",


    "global" => "<p>Global Links are used to control whether or not your comment usernames are used as outbound links.</p><p>Link N% of all comment names - By setting this to 0% no comment usernames will be linked. By setting it to 100% all comment usernames will be linked. By setting it to a percentage between 0-100 then a proportion of all comment usernames will be linked e.g. setting 50% will mean that half of all comment usernames are linked.</p><p>DO/NO Follow global links - In order to tackle comment spam most blogs now automatically add a rel=_NoFollow_ tag to outbound links. CommentPiG Pro allows you to choose whether search engines should follow your Global outbound links. Choosing DO means that search engines will follow Global Links and NO means that they won't. NB: This setting is for Global Links only. You can control the setting for your own links below.</p><p>Use random/authority sites - You can also choose if the Global Links should be chosen randomly from safe sites in the Yahoo Directory or you can link to authority sites which appear in the top 50 for the Yahoo search result for the post target. You can choose both sources to give a blended approach.</p>",


    "my sites" => "<p>Now you have decided what proportion of ALL comments should contain ANY links you need to specify what proportion of ALL linked comments should link to your own sites and affiliate links.</p><p>Link N% of linked comment names to my sites - If you have chosen that a percentage of all usernames should be linked you can now choose how many of those linked usernames should contain your Own Links. Simply enter a percentage from 1 - 100 into the box.</p><p>DO/NO Follow My Sites links - As with Global Links can choose whether search engines should follow your Own Links by changing the DO or NO Follow setting.</p><p>Use these sites - Use the list-box to enter your Own Links. Enter one URL per line. CommentPiG Pro will select your links randomly from this list.</p>",

    "initial settings" => "<p>Downloads the current settings for your plugin. Can be used to configure the initial settings on a different site.</p>",

	);

  $headers = array(
    'blogpig-api-key' => 'http://blogpig.com/help/faqs/commentpig/how-to-enter-your-blogpig-api-key',
    'commentpig-general' => 'http://blogpig.com/help/faqs/commentpig/commentpig-general-settings',
    'commentpig-sources' => 'http://blogpig.com/help/faqs/commentpig/commentpig-source-settings',
    'commentpig-filters' => 'http://blogpig.com/help/faqs/commentpig/commentpig-filter-settings',
    'commentpig-local-db' => '',
    'commentpig-links' => '',
    'blogpig-clone-settings' => '',
    'blogpig-log' => '',
  );
?>
