/*
 * Decompiled with CFR 0.152.
 */
package JUpload.utilities;

import JUpload.swingVersion.UploadJob;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MD5;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MyFile
extends File {
    private static final long serialVersionUID = 3258693195591135541L;
    private File currentDirectory = null;
    private boolean queued = false;
    private boolean uploaded = false;
    private String md5hash = null;
    private boolean virtual = false;
    private byte[] virtualData = new byte[0];
    private String m_virtualRelativeFilename = null;
    private String m_virtualFilename = null;
    private UploadJob job;
    private boolean hasFailure;

    public MyFile(String pathname) {
        super(pathname);
        Debug.println(this, "MyFile, 1 new instance for " + pathname);
    }

    public MyFile(MyFile file) {
        super(file.getParentFile(), file.getName());
        Debug.println(this, "Cloning myFile " + file);
        this.setCurrentDirectory(file.getCurrentDirectory());
        this.setVirtual(file.isVirtual());
        if (file.isVirtual()) {
            this.setVirtualData(file.getVirtualData());
            this.setVirtual(true);
        }
    }

    public MyFile(File file) {
        super(file.getParentFile(), file.getName());
        Debug.println(this, "MyFile, 2 new instance for " + file);
    }

    public MyFile(File parent, String child) {
        super(parent, child);
        Debug.println(this, "MyFile, 3 new instance for " + parent + " -- " + child);
    }

    public MyFile(String parent, String child) {
        super(parent, child);
        Debug.println(this, "MyFile, 4 new instance for " + parent + " -- " + child);
    }

    public void setCurrentDirectory(File directory) {
        this.currentDirectory = directory;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String getRelativeFilename() {
        if (!Configurator.getUseRecursivePaths()) {
            return this.getName();
        }
        String fullPath = this.getAbsolutePath();
        try {
            fullPath = this.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fullPath == null) {
            return "";
        }
        String basePath = "";
        if (this.currentDirectory != null && (basePath = this.currentDirectory.getAbsolutePath()) == null) {
            try {
                basePath = this.currentDirectory.getCanonicalPath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (fullPath.toLowerCase().startsWith(basePath.toLowerCase())) {
            String rel = fullPath.substring(basePath.length());
            while (rel.startsWith(File.separator)) {
                rel = rel.substring(1);
            }
            return rel;
        }
        return fullPath;
    }

    public Color getColor() {
        if (this.queued) {
            return Color.green;
        }
        return Color.white;
    }

    public void setQueued(boolean status) {
        this.queued = status;
    }

    public void setUploaded(boolean b) {
        this.uploaded = b;
    }

    public boolean isUploaded() {
        return this.uploaded;
    }

    public synchronized String getMD5Hash() {
        if (this.md5hash == null && Configurator.getCalculateMD5Hash()) {
            int c;
            long startTime = System.currentTimeMillis();
            MD5 md5 = new MD5();
            byte[] b = new byte[0x100000];
            byte[] digest = new byte[16];
            InputStream is = null;
            if (this.isVirtual()) {
                is = new ByteArrayInputStream(this.getVirtualData());
            } else {
                try {
                    is = new FileInputStream(this.getAbsoluteFile());
                }
                catch (FileNotFoundException e) {
                    Debug.println(this, "i am no file, but isVirtual is false:" + this.isVirtual());
                    return null;
                }
            }
            do {
                try {
                    c = is.read(b);
                }
                catch (IOException e) {
                    return null;
                }
                if (c > 0) {
                    md5.update(b, c);
                    continue;
                }
                md5.md5final(digest);
            } while (c > 0);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                String s;
                if (i % 32 == 0 && i != 0) {
                    sb.append("\n");
                }
                if ((s = Integer.toHexString(digest[i])).length() < 2) {
                    s = "0" + s;
                }
                if (s.length() > 2) {
                    s = s.substring(s.length() - 2);
                }
                sb.append(s);
            }
            this.md5hash = sb.toString();
            long endTime = System.currentTimeMillis();
            Debug.println(this, "Calculating MD5 hash took " + (endTime - startTime) + " ms");
        }
        return this.md5hash;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean t_virtual) {
        this.virtual = t_virtual;
        if (this.m_virtualFilename == null) {
            this.m_virtualFilename = this.getName();
        }
        if (this.m_virtualRelativeFilename == null) {
            this.m_virtualRelativeFilename = this.currentDirectory == null ? this.getName() : this.getRelativeFilename();
        }
    }

    public byte[] getVirtualData() {
        return this.virtualData;
    }

    public void setVirtualData(byte[] t_virtualData) {
        this.virtualData = t_virtualData;
    }

    public long length() {
        if (this.isVirtual()) {
            return this.virtualData.length;
        }
        return super.length();
    }

    public boolean exists() {
        if (this.isVirtual()) {
            return true;
        }
        return super.exists();
    }

    public void setVirtualRelativePathname(String t_virtualRelativeFilename) {
        this.m_virtualRelativeFilename = t_virtualRelativeFilename;
        int pos = this.m_virtualRelativeFilename.lastIndexOf(File.separatorChar);
        this.m_virtualFilename = pos >= 0 ? this.m_virtualRelativeFilename.substring(pos + 1) : this.m_virtualRelativeFilename;
    }

    public String getVirtualRelativePathname() {
        return this.m_virtualRelativeFilename;
    }

    public String getVirtualFilename() {
        return this.m_virtualFilename;
    }

    public void setJob(UploadJob job) {
        this.job = job;
    }

    public boolean hasJob() {
        return this.job != null;
    }

    public UploadJob getJob() {
        return this.job;
    }

    public boolean hasFailure() {
        return this.hasFailure;
    }

    public void setFailure(boolean flag) {
        this.hasFailure = flag;
    }
}

