/*
 * Decompiled with CFR 0.152.
 */
package JUpload.utilities;

import JUpload.Messages;
import JUpload.utilities.MyFile;
import JUpload.utilities.Preferences;
import java.applet.Applet;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configurator {
    private static final Logger logger = Logger.getLogger((class$JUpload$utilities$Configurator == null ? (class$JUpload$utilities$Configurator = Configurator.class$("JUpload.utilities.Configurator")) : class$JUpload$utilities$Configurator).getName());
    public static String strApplicationName = "JUpload";
    public static String strApplicationVersion = "0.88";
    public static String strApplicationAuthor = "Haller Systemservice";
    public static String strApplicationEmail = "info@jupload.biz";
    public static String strApplicationWeb = "http://jupload.biz/";
    public static String strBanner = strApplicationName + " v" + strApplicationVersion;
    public static String strUserAgent = strApplicationName + "/" + strApplicationVersion;
    private static Properties defaultprops = new Properties();
    private static Properties props = new Properties();
    private static Applet applet;
    private static String strWWWAuthentificationString;
    private static String[][] settings;
    static File PREFERENCES_FILE;
    private static Preferences preferences;
    static /* synthetic */ Class class$JUpload$utilities$Configurator;

    public static void reset() {
        props = new Properties();
        defaultprops = new Properties();
    }

    private static void readSettings() {
        settings = new String[][]{{"backgroundColor", "#e0e0e0", "String"}, {"completeURL", "", "URL"}, {"actionURL", "", "URL"}, {"askAuthentification", "false", "Boolean"}, {"tagName", "uploadedFiles", "String"}, {"checkResponse", "true", "Boolean"}, {"showSuccessDialog", "true", "Boolean"}, {"imageFileFilter", "false", "Boolean"}, {"hideShowAll", "false", "Boolean"}, {"showPicturePreview", "true", "Boolean"}, {"addWindowTitle", Messages.getString("Configurator.38"), "String"}, {"labelFiles", Messages.getString("Configurator.44"), "String"}, {"labelBytes", Messages.getString("Configurator.47"), "String"}, {"labelAdd", Messages.getString("Configurator.50"), "String"}, {"labelRemove", Messages.getString("Configurator.53"), "String"}, {"labelUpload", Messages.getString("Configurator.56"), "String"}, {"successDialogMessage", Messages.getString("Configurator.59"), "String"}, {"successDialogTitle", Messages.getString("Configurator.62"), "String"}, {"addToolTip", Messages.getString("Configurator.65"), "String"}, {"removeToolTip", Messages.getString("Configurator.68"), "String"}, {"uploadToolTip", Messages.getString("Configurator.71"), "String"}, {"useRecursivePaths", "true", "Boolean"}, {"debug", "false", "Boolean"}, {"checkJavaVersion", "false", "Boolean"}, {"checkJavaVersionGotoURL", Messages.getString("Configurator.83"), "URL"}, {"browserCookie", "", "String"}, {"defaultAddDirectory", "", "String"}, {"usePutMethod", "false", "Boolean"}, {"maxFreeSpaceOnServer", "-1", "Long"}, {"maxFreeSpaceOnServerWarning", Messages.getString("Configurator.98"), "String"}, {"maxFreeSpaceOnServerTitle", Messages.getString("Configurator.101"), "String"}, {"maxTotalRequestSize", "-1", "Long"}, {"maxTotalRequestSizeWarning", Messages.getString("Configurator.107"), "String"}, {"maxTotalRequestSizeTitle", Messages.getString("Configurator.110"), "String"}, {"customFileFilter", "false", "Boolean"}, {"customFileFilterDescription", Messages.getString("Configurator.116"), "String"}, {"customFileFilterExtensions", "gif,jpeg,jpg,png,bmp,tif", "String"}, {"maxNumberFiles", "-1", "Integer"}, {"maxNumberFilesWarning", Messages.getString("Configurator.125"), "String"}, {"maxNumberFilesTitle", Messages.getString("Configurator.128"), "String"}, {"fixJakartaBug", "false", "Boolean"}, {"maxFilesPerRequest", "-1", "Integer"}, {"showServerResponse", "true", "Boolean"}, {"errorURL", "", "URL"}, {"preselectedFiles", "", Messages.getString("Configurator.144")}, {"realTimeResponse", "true", "Boolean"}, {"mainSplitpaneLocation", "0", "Integer"}, {"hideAddButton", "false", "Boolean"}, {"hideRemoveButton", "false", "Boolean"}, {"hideUploadButton", "false", "Boolean"}, {"showStatusPanel", "true", "Boolean"}, {"skinThemePackURL", "", "URL"}, {"leftSplitpaneLocation", "120", "Integer"}, {"useProxy", "true", "Boolean"}, {"showThumbnails", "false", "Boolean"}, {"targetFrame", "", "String"}, {"useAbsolutePaths", "true", "Boolean"}, {"showSystemIcons", "true", "Boolean"}, {"preventDoubles", "true", "Boolean"}, {"preventRecursion", "false", "Boolean"}, {"showFilePaths", "false", "Boolean"}, {"lookAndFeelClass", "", "String"}, {"PUTQueryString", "", "String"}, {"overwriteContentType", "false", "Boolean"}, {"usePresetAuthentification", "", "String"}, {"pluginClasses", "", "String"}, {"disableContextMenu", "false", "Boolean"}, {"PUTFragmentSize", "1073741824", "Integer"}, {"useFTPMethod", "false", "Boolean"}, {"captureScreen", "true", "Boolean"}, {"dimensionFilter", "", "String"}, {"alwaysAcceptCertificates", "true", "Boolean"}, {"foregroundColor", "", "String"}, {"autoselectLastFile", "false", "Boolean"}, {"autoGZipCompression", "true", "Boolean"}, {"filechooserPreviewChecked", "true", "Boolean"}, {"filechooserPreviewQuality", "false", "Boolean"}, {"replaceDocument", "false", "Boolean"}, {"sendLastModificationDate", "false", "Boolean"}, {"skipNewlineAfterHeader", "false", "Boolean"}, {"thumbWidth", "32", "Integer"}, {"thumbHeight", "32", "Integer"}, {"regexFileFilter", "", "String"}, {"convertImagesToFormat", "", "String"}, {"resizeImageMaxWidth", "0", "Integer"}, {"resizeImageMaxHeight", "0", "Integer"}, {"removeBorders", "true", "Boolean"}, {"showErrorsOnAdd", "true", "Boolean"}, {"autostartUpload", "false", "Boolean"}, {"localeLanguage", "", "String"}, {"localeCountry", "", "String"}, {"localeVariant", "", "String"}, {"labelStopUpload", Messages.getString("Configurator.labelStopUpload"), "String"}, {"resizeInterpolationAlgorithm", "none", "String (bilinear|bicubic|nearest|none)"}, {"calculateMD5Hash", "true", "Boolean"}, {"improvedShrinking", "false", "Boolean"}, {"resizeWithMetadata", "false", "Boolean"}, {"encryptContent", "false", "Boolean"}, {"encryptPublicKeyURL", "", "URL"}, {"hideStopButton", "false", "Boolean"}, {"captureScreenDelay", "5", "Integer"}, {"showTabViews", "list,details,tree", "String (list &| details &| tree)"}, {"maxRetries", "3", "Integer"}};
        for (int i = 0; i < settings.length; ++i) {
            String strKey = settings[i][0];
            String strDefaultValue = settings[i][1];
            defaultprops.put(strKey, strDefaultValue);
        }
        props.putAll((Map<?, ?>)defaultprops);
    }

    public static URL getActionURL() {
        String strValue = (String)props.get("actionURL");
        if (Configurator.getUsePutMethod() && !strValue.endsWith("/")) {
            strValue = strValue + "/";
        }
        try {
            if (applet != null) {
                URL url = new URL(applet.getCodeBase(), strValue);
                return url;
            }
            if (applet == null) {
                URL url = new URL(strValue);
                return url;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getAddToolTip() {
        return (String)props.get("addToolTip");
    }

    public static String getAddWindowTitle() {
        return (String)props.get("addWindowTitle");
    }

    public static boolean getAskAuthentificate() {
        String strValue = (String)props.get("askAuthentification");
        return Configurator.checkBoolean(strValue);
    }

    public static Color getBackgroundColor() {
        if (props == null) {
            return null;
        }
        String strBackgroundColor = (String)props.get("backgroundColor");
        Color colBackgroundColor = Configurator.getColor(strBackgroundColor);
        return colBackgroundColor;
    }

    public static String getBrowserCookie() {
        return (String)props.get("browserCookie");
    }

    public static boolean getCheckResponse() {
        String strCheckResponse = (String)props.get("checkResponse");
        return Configurator.checkBoolean(strCheckResponse);
    }

    public static URL getCompleteURL() {
        String strValue = (String)props.get("completeURL");
        URL url = null;
        if (strValue.equals("")) {
            return null;
        }
        try {
            url = new URL(strValue);
        }
        catch (MalformedURLException e) {
            URL baseurl = applet.getCodeBase();
            try {
                url = new URL(baseurl + strValue);
            }
            catch (MalformedURLException e2) {
                try {
                    url = new URL((String)defaultprops.get("completeURL"));
                }
                catch (MalformedURLException e1) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public static boolean getCustomFileFilter() {
        String strValue = (String)props.get("customFileFilter");
        return Configurator.checkBoolean(strValue);
    }

    public static String getCustomFileFilterDescription() {
        return (String)props.get("customFileFilterDescription");
    }

    public static String getCustomFileFilterExtensions() {
        return (String)props.get("customFileFilterExtensions");
    }

    public static boolean getDebug() {
        if (null == props) {
            return false;
        }
        String strValue = (String)props.get("debug");
        return Configurator.checkBoolean(strValue);
    }

    public static String getDefaultAddDirectory() {
        return (String)props.get("defaultAddDirectory");
    }

    public static URL getErrorURL() {
        String strValue = (String)props.get("errorURL");
        URL url = null;
        if (strValue.equals("")) {
            return null;
        }
        try {
            url = new URL(strValue);
        }
        catch (MalformedURLException e) {
            URL baseurl = applet.getCodeBase();
            try {
                url = new URL(baseurl + strValue);
            }
            catch (MalformedURLException e2) {
                try {
                    url = new URL((String)defaultprops.get("errorURL"));
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return url;
    }

    public static boolean getFixJakartaBug() {
        String strValue = (String)props.get("fixJakartaBug");
        return Configurator.checkBoolean(strValue);
    }

    public static String getHTTPTagName() {
        return (String)props.get("tagName");
    }

    public static boolean getHideAddButton() {
        String strValue = (String)props.get("hideAddButton");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getHideRemoveButton() {
        String strValue = (String)props.get("hideRemoveButton");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getHideShowAll() {
        String strValue = (String)props.get("hideShowAll");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getHideUploadButton() {
        String strValue = (String)props.get("hideUploadButton");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getImageFileFilter() {
        String strValue = (String)props.get("imageFileFilter");
        return Configurator.checkBoolean(strValue);
    }

    public static String getLabelAdd() {
        return (String)props.get("labelAdd");
    }

    public static String getLabelBytes() {
        return (String)props.get("labelBytes");
    }

    public static String getLabelFiles() {
        return (String)props.get("labelFiles");
    }

    public static String getLabelRemove() {
        return (String)props.get("labelRemove");
    }

    public static String getLabelUpload() {
        return (String)props.get("labelUpload");
    }

    public static int getMainSplitpaneLocation() {
        return Configurator.getInt("mainSplitpaneLocation");
    }

    public static int getMaxFilesPerRequest() {
        return Configurator.getInt("maxFilesPerRequest");
    }

    public static long getMaxFreeSpaceOnServer() {
        String strValue = (String)props.get("maxFreeSpaceOnServer");
        long lValue = 0L;
        try {
            lValue = Long.parseLong(strValue);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lValue;
    }

    public static String getMaxFreeSpaceOnServerTitle() {
        return (String)props.get("maxFreeSpaceOnServerTitle");
    }

    public static String getMaxFreeSpaceOnServerWarning() {
        return (String)props.get("maxFreeSpaceOnServerWarning");
    }

    public static int getMaxNumberFiles() {
        return Configurator.getInt("maxNumberFiles");
    }

    public static String getMaxNumberFilesTitle() {
        return (String)props.get("maxNumberFilesTitle");
    }

    public static String getMaxNumberFilesWarning() {
        return (String)props.get("maxNumberFilesWarning");
    }

    public static long getMaxTotalRequestSize() {
        return Configurator.getInt("maxTotalRequestSize");
    }

    public static String getMaxTotalRequestSizeTitle() {
        return (String)props.get("maxTotalRequestSizeTitle");
    }

    public static String getMaxTotalRequestSizeWarning() {
        return (String)props.get("maxTotalRequestSizeWarning");
    }

    public static MyFile[] getPreselectedFiles() {
        String preselectedFiles = (String)props.get("preselectedFiles");
        StringTokenizer token = new StringTokenizer(preselectedFiles, ";|");
        int number = token.countTokens();
        MyFile[] fileArray = new MyFile[number];
        logger.info("Number of preselected files: " + number);
        for (int i = 0; i < number; ++i) {
            fileArray[i] = new MyFile(token.nextToken());
            logger.finer("Preselected file " + fileArray[i]);
        }
        return fileArray;
    }

    public static boolean getRealTimeResponse() {
        String strValue = (String)props.get("realTimeResponse");
        return Configurator.checkBoolean(strValue);
    }

    public static String getRemoveToolTip() {
        return (String)props.get("removeToolTip");
    }

    public static boolean getShowPicturePreview() {
        String strValue = (String)props.get("showPicturePreview");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getShowServerResponse() {
        String strValue = (String)props.get("showServerResponse");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getShowStatusPanel() {
        String strValue = (String)props.get("showStatusPanel");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getShowSuccessDialog() {
        String strShowSuccessDialog = (String)props.get("showSuccessDialog");
        return Configurator.checkBoolean(strShowSuccessDialog);
    }

    public static URL getSkinThemePackURL() {
        String strValue = (String)props.get("skinThemePackURL");
        URL url = null;
        if (strValue == null) {
            return null;
        }
        if (strValue.equals("")) {
            return null;
        }
        try {
            url = new URL(strValue);
        }
        catch (MalformedURLException e) {
            URL baseurl = applet.getCodeBase();
            try {
                url = new URL(baseurl + strValue);
            }
            catch (MalformedURLException e2) {
                try {
                    url = new URL((String)defaultprops.get("skinThemePackURL"));
                }
                catch (MalformedURLException e1) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public static String getSuccessDialogMessage() {
        return (String)props.get("successDialogMessage");
    }

    public static String getSuccessDialogTitle() {
        return (String)props.get("successDialogTitle");
    }

    public static String getUploadToolTip() {
        return (String)props.get("uploadToolTip");
    }

    public static boolean getUsePutMethod() {
        String strValue = (String)props.get("usePutMethod");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getUseRecursivePaths() {
        String strValue = (String)props.get("useRecursivePaths");
        return Configurator.checkBoolean(strValue);
    }

    public static void changeProperty(String strKey, String strValue) {
        props.put(strKey, strValue);
    }

    public static String helpPage() {
        String helpPage = "<applet \n  code=\"JUpload/startup.class\"\n  archive=\"JUpload.jar\"\n  width=\"450\"\n  height=\"200\"\n  alt=\"JUpload java applet for uploading multiple files at once with http post method\">\n <!-- Java Plug-In Options -->\n <param name=\"progressbar\" value=\"true\">\n <param name=\"boxmessage\" value=\"Loading JUpload Applet ...\">\n <param name=\"boxbgcolor\" value=\"#e0e0ff\">\n\n\n";
        for (int i = 0; i < settings.length; ++i) {
            String strKey = settings[i][0];
            String strValue = settings[i][1];
            String strType = settings[i][2];
            helpPage = helpPage + "<PARAM NAME=\"" + strKey + "\" VALUE=\"" + strValue + "\"><!-- Type is " + strType + " -->\n";
        }
        helpPage = helpPage + "</applet>";
        return helpPage;
    }

    public static void readConfiguration(Applet t_applet) {
        Configurator.readSettings();
        applet = t_applet;
        Configurator.debug("Configurator() there are " + settings.length + " known parameters.");
        for (int i = 0; i < settings.length; ++i) {
            String strKey = settings[i][0];
            String strDefaultValue = settings[i][1];
            String strKeyType = settings[i][2];
            String strUserValue = null;
            if (t_applet != null) {
                strUserValue = t_applet.getParameter(strKey);
            }
            Configurator.debug("Configurator() key=[" + strKey + "] default=[" + strDefaultValue + "] uservalue=[" + strUserValue + "] type=[" + strKeyType + "]");
            defaultprops.put(strKey, strDefaultValue);
            if (null == strUserValue) {
                props.put(strKey, strDefaultValue);
                continue;
            }
            props.put(strKey, strUserValue);
        }
    }

    private static Color getColor(String string) {
        Color col;
        try {
            String strRed = string.substring(1, 3);
            String strGreen = string.substring(3, 5);
            String strBlue = string.substring(5, 7);
            int iRed = Integer.parseInt(strRed, 16);
            int iGreen = Integer.parseInt(strGreen, 16);
            int iBlue = Integer.parseInt(strBlue, 16);
            col = new Color(iRed, iGreen, iBlue);
        }
        catch (NullPointerException e) {
            col = Color.white;
        }
        return col;
    }

    private static boolean checkBoolean(String strCheckResponse) {
        if (strCheckResponse == null) {
            return false;
        }
        if (strCheckResponse.equalsIgnoreCase("false")) {
            return false;
        }
        if (strCheckResponse.equalsIgnoreCase("0")) {
            return false;
        }
        if (strCheckResponse.equalsIgnoreCase("off")) {
            return false;
        }
        if (strCheckResponse.equalsIgnoreCase("no")) {
            return false;
        }
        if (strCheckResponse.equalsIgnoreCase("true")) {
            return true;
        }
        if (strCheckResponse.equalsIgnoreCase("1")) {
            return true;
        }
        if (strCheckResponse.equalsIgnoreCase("on")) {
            return true;
        }
        return strCheckResponse.equalsIgnoreCase("yes");
    }

    private static void debug(String string) {
    }

    public static String getStrWWWAuthentificationString() {
        return strWWWAuthentificationString;
    }

    public static void setStrWWWAuthentificationString(String t_newString) {
        strWWWAuthentificationString = t_newString;
    }

    public static int getLeftSplitpaneLocation() {
        return Configurator.getInt("leftSplitpaneLocation");
    }

    public static boolean getUseProxy() {
        String strValue = (String)props.get("useProxy");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getShowThumbnails() {
        String strValue = (String)props.get("showThumbnails");
        return Configurator.checkBoolean(strValue);
    }

    public static String getTargetFrame() {
        return (String)props.get("targetFrame");
    }

    public static boolean getUseAbsolutePaths() {
        String strValue = (String)props.get("useAbsolutePaths");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getShowSystemIcons() {
        String strValue = (String)props.get("showSystemIcons");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getPreventDoubles() {
        String strValue = (String)props.get("preventDoubles");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getPreventRecursion() {
        String strValue = (String)props.get("preventRecursion");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getShowFilePaths() {
        String strValue = (String)props.get("showFilePaths");
        return Configurator.checkBoolean(strValue);
    }

    public static String getLookAndFeelClass() {
        return (String)props.get("lookAndFeelClass");
    }

    public static String getPUTQueryString() {
        return (String)props.get("PUTQueryString");
    }

    public static boolean getOverwriteContentType() {
        String strValue = (String)props.get("overwriteContentType");
        return Configurator.checkBoolean(strValue);
    }

    public static String getUsePresetAuthentification() {
        return (String)props.get("usePresetAuthentification");
    }

    public static String getPluginClasses() {
        return (String)props.get("pluginClasses");
    }

    public static boolean getDisableContextMenu() {
        String strValue = (String)props.get("disableContextMenu");
        return Configurator.checkBoolean(strValue);
    }

    public static long getPUTFragmentSize() {
        return Configurator.getInt("PUTFragmentSize");
    }

    public static boolean getUseFTPMethod() {
        String strValue = (String)props.get("useFTPMethod");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getCaptureScreen() {
        String strValue = (String)props.get("captureScreen");
        return Configurator.checkBoolean(strValue);
    }

    public static String getDimensionFilter() {
        return (String)props.get("dimensionFilter");
    }

    public static boolean getAlwaysAcceptCertificates() {
        String strValue = (String)props.get("alwaysAcceptCertificates");
        return Configurator.checkBoolean(strValue);
    }

    public static Color getForegroundColor() {
        if (props == null) {
            return null;
        }
        String strColor = (String)props.get("foregroundColor");
        if (strColor.equals("")) {
            return null;
        }
        Color color = Configurator.getColor(strColor);
        return color;
    }

    public static boolean getAutoselectLastFile() {
        String strValue = (String)props.get("autoselectLastFile");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getAutoGZipCompression() {
        String strValue = (String)props.get("autoGZipCompression");
        return Configurator.checkBoolean(strValue);
    }

    public static List getAdditionalHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        int i = 0;
        String strValue = null;
        do {
            if ((strValue = applet.getParameter("additionalHeader" + i)) == null) continue;
            headers.add(strValue);
        } while (strValue != null || ++i == 0);
        return headers;
    }

    public static boolean getFilechooserPreviewChecked() {
        String strValue = (String)props.get("filechooserPreviewChecked");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getFilechooserPreviewQuality() {
        String strValue = (String)props.get("filechooserPreviewQuality");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getReplaceDocument() {
        String strValue = (String)props.get("replaceDocument");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getSendLastModificationDate() {
        String strValue = (String)props.get("sendLastModificationDate");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getSkipNewlineAfterHeader() {
        String strValue = (String)props.get("skipNewlineAfterHeader");
        return Configurator.checkBoolean(strValue);
    }

    public static int getThumbWidth() {
        return Configurator.getInt("thumbWidth");
    }

    public static int getThumbHeight() {
        return Configurator.getInt("thumbHeight");
    }

    public static String getRegexFileFilter() {
        return (String)props.get("regexFileFilter");
    }

    public static String getConvertImagesToFormat() {
        return (String)props.get("convertImagesToFormat");
    }

    public static int getResizeImageMaxWidth() {
        return Configurator.getInt("resizeImageMaxWidth");
    }

    public static int getResizeImageMaxHeight() {
        return Configurator.getInt("resizeImageMaxHeight");
    }

    public static boolean getRemoveBorders() {
        String strValue = (String)props.get("removeBorders");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getShowErrorsOnAdd() {
        String strValue = (String)props.get("showErrorsOnAdd");
        return Configurator.checkBoolean(strValue);
    }

    public static Properties getProperties() {
        return props;
    }

    public static Properties getDefaultProperties() {
        return defaultprops;
    }

    public static boolean getAutostartUpload() {
        String strValue = (String)props.get("autostartUpload");
        return Configurator.checkBoolean(strValue);
    }

    public static Locale getLocale() {
        String strLanguage = (String)props.get("localeLanguage");
        String strCountry = (String)props.get("localeCountry");
        String strVariant = (String)props.get("localeVariant");
        if (strLanguage.equals("")) {
            return null;
        }
        if (strCountry.equals("")) {
            return new Locale(strLanguage, "");
        }
        if (strVariant.equals("")) {
            return new Locale(strLanguage, strCountry);
        }
        return new Locale(strLanguage, strCountry, strVariant);
    }

    public static String getLabelStopUpload() {
        return (String)props.get("labelStopUpload");
    }

    public static Map getAdditionalPOSTFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        String strPattern = null;
        do {
            if ((strPattern = applet.getParameter("additionalPOSTFields" + i)) == null) continue;
            int pos = strPattern.indexOf("=");
            String strKey = strPattern.substring(0, pos);
            String strValue = strPattern.substring(pos + 1);
            map.put(strKey, strValue);
        } while (strPattern != null || ++i == 0);
        return map;
    }

    public static String getResizeInterpolationAlgorithm() {
        return (String)props.get("resizeInterpolationAlgorithm");
    }

    public static boolean getCalculateMD5Hash() {
        String strValue = (String)props.get("calculateMD5Hash");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getImprovedShrinking() {
        String strValue = (String)props.get("improvedShrinking");
        return Configurator.checkBoolean(strValue);
    }

    public static boolean getResizeWithMetadata() {
        String strValue = (String)props.get("resizeWithMetadata");
        return Configurator.checkBoolean(strValue);
    }

    public static Preferences getPreferences() {
        return preferences;
    }

    public static boolean getEncryptContent() {
        String strValue = (String)props.get("encryptContent");
        return Configurator.checkBoolean(strValue);
    }

    public static URL getEncryptPublicKeyURL() {
        String strValue = (String)props.get("encryptPublicKeyURL");
        URL url = null;
        if (strValue.equals("")) {
            return null;
        }
        try {
            url = new URL(strValue);
        }
        catch (MalformedURLException e) {
            URL baseurl = applet.getCodeBase();
            logger.warning("Malformed URL " + strValue);
            try {
                String url2 = baseurl + strValue;
                logger.info("Trying to prefix with baseurl: " + url2);
                url = new URL(url2);
            }
            catch (MalformedURLException e2) {
                try {
                    url = new URL((String)defaultprops.get("encryptPublicKeyURL"));
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return url;
    }

    public static boolean getHideStopButton() {
        String strValue = (String)props.get("hideStopButton");
        return Configurator.checkBoolean(strValue);
    }

    public static int getCaptureScreenDelay() {
        return Configurator.getInt("captureScreenDelay");
    }

    public static String getShowTabViews() {
        return (String)props.get("showTabViews");
    }

    public static int getMaxRetries() {
        return Configurator.getInt("maxRetries");
    }

    private static int getInt(String property) {
        String strValue = (String)props.get(property);
        int lValue = 0;
        try {
            lValue = Integer.parseInt(strValue);
        }
        catch (Exception e) {
            String errmsg = "Error parsing number " + strValue;
            logger.log(Level.WARNING, errmsg, e);
        }
        if (defaultprops.contains(property)) {
            String defaultValue = defaultprops.getProperty(property);
            try {
                lValue = Integer.parseInt(defaultValue);
            }
            catch (Exception e) {
                String errmsg = "Error parsing default value " + defaultValue;
                logger.log(Level.WARNING, errmsg, e);
            }
        }
        return lValue;
    }

    public static void setProperty(String key, String value) {
        props.put(key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PREFERENCES_FILE = new File(System.getProperty("user.home"), ".jupload.properties");
        preferences = new Preferences();
        Configurator.readSettings();
        try {
            preferences.load(new FileInputStream(PREFERENCES_FILE));
            logger.info("User preferences loaded: " + PREFERENCES_FILE);
        }
        catch (FileNotFoundException e) {
            preferences.store();
            logger.info("User preferences created: " + PREFERENCES_FILE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

