/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.swingVersion.JUpload;
import JUpload.utilities.Configurator;
import JUpload.utilities.MyFile;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class myListCellRenderer
implements ListCellRenderer {
    private ImageIcon previewIcon = null;
    private ImageIcon original = null;
    private boolean showThumbs = Configurator.getShowThumbnails();
    private boolean showSystemicons = Configurator.getShowSystemIcons();
    private boolean showFilePaths;
    private MyFile fileName;
    private Map labels;
    private JLabel label;
    private int thumbWidth = Configurator.getThumbWidth();
    private int thumbHeight = Configurator.getThumbHeight();

    myListCellRenderer() {
        this.showFilePaths = Configurator.getShowFilePaths();
        this.labels = new HashMap();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.labels.containsKey(value)) {
            MyFile file = (MyFile)value;
            this.label = (JLabel)this.labels.get(value);
            if (isSelected) {
                this.label.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            if (file.isUploaded()) {
                this.label.setIcon(JUpload.ICON_DONE);
            }
            if (file.hasFailure()) {
                this.label.setIcon(JUpload.ICON_ERROR);
            }
            return this.label;
        }
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.fileName = (MyFile)value;
        if (this.showFilePaths) {
            if (this.fileName.isVirtual() && this.fileName.getVirtualRelativePathname() != null) {
                this.label.setText(this.fileName.getVirtualRelativePathname());
            } else {
                this.label.setText(this.fileName.getRelativeFilename());
            }
        } else if (this.fileName.isVirtual() && this.fileName.getVirtualFilename() != null) {
            this.label.setText(this.fileName.getVirtualFilename());
        } else {
            this.label.setText(this.fileName.getName());
        }
        this.label.setBackground(this.fileName.getColor());
        if (this.showSystemicons && !this.fileName.isVirtual()) {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            try {
                this.label.setIcon(fsv.getSystemIcon(this.fileName.getAbsoluteFile()));
            }
            catch (Error e) {
                // empty catch block
            }
        }
        if (this.showSystemicons && this.fileName.isVirtual()) {
            this.label.setIcon(UIManager.getIcon("FileView.fileIcon"));
        }
        if (this.showThumbs) {
            this.original = this.fileName.isVirtual() ? new ImageIcon(this.fileName.getVirtualData()) : new ImageIcon(this.fileName.getPath());
            this.previewIcon = new ImageIcon(this.original.getImage().getScaledInstance(this.thumbWidth, this.thumbHeight, 4));
            if (this.previewIcon != null) {
                this.label.setIcon(this.previewIcon);
            }
            this.previewIcon = null;
            this.original = null;
        }
        this.label.setToolTipText(this.fileName.getAbsolutePath());
        this.label.setEnabled(list.isEnabled());
        this.label.setFont(list.getFont());
        this.label.setOpaque(true);
        this.labels.put(value, this.label);
        return this.label;
    }
}

