/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.Messages;
import JUpload.gui.UploadStatus;
import JUpload.imaging.ImageingUtilities;
import JUpload.queuefilter.IQueueFilter;
import JUpload.queuefilter.ImageDimensionFilter;
import JUpload.startup;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import netscape.javascript.JSObject;

public class WalkerThread
implements ImageObserver {
    private JFileChooser m_jfc;
    private static WalkerThread M_instance;
    private JUpload m_parent;
    private startup m_applet;
    private File m_currentDirectory;
    private List m_listeners;
    private UploadStatus myStatus;
    private List notAdded = new ArrayList();

    private WalkerThread() {
        M_instance = this;
        this.m_parent = JUpload.getInstance();
        if (this.m_parent == null) {
            return;
        }
        this.m_applet = this.m_parent.applet;
        this.m_listeners = new ArrayList();
        if (!Configurator.getDimensionFilter().equals("")) {
            this.addQueueFilterListener(new ImageDimensionFilter());
        }
    }

    public void addQueueFilterListener(IQueueFilter t_listener) {
        if (!this.m_listeners.contains(t_listener)) {
            this.m_listeners.add(t_listener);
        }
    }

    public void removeQueueFilterListener(IQueueFilter t_listener) {
        if (this.m_listeners.contains(t_listener)) {
            this.m_listeners.remove(t_listener);
        }
    }

    public boolean fireQueueFilterListener(MyFile t_file) {
        Iterator iter = this.m_listeners.iterator();
        while (iter.hasNext()) {
            IQueueFilter filter = (IQueueFilter)iter.next();
            boolean status = filter.beforeQueueing(t_file);
            if (status) continue;
            return false;
        }
        return true;
    }

    private Collection walkFileTree(MyFile[] t_files) {
        this.notAdded.clear();
        if (t_files.length == 0) {
            Debug.println(this, "WalkerThread() No files to add");
            return this.notAdded;
        }
        if (this.myStatus != null) {
            this.myStatus.setMessage(Messages.getString("ImageConverter.AddingFiles", Integer.toString(t_files.length)));
            this.myStatus.setTotalProgressbarVisible(true);
        }
        for (int i = 0; i < t_files.length; ++i) {
            MyFile newFile = t_files[i];
            if (this.myStatus != null) {
                this.myStatus.setTotalValue(i, t_files.length);
            }
            if (!this.fireQueueFilterListener(newFile)) {
                this.notAdded.add(Messages.getString("WalkerThread.filefilter.errormessage.filepermitted") + newFile);
                continue;
            }
            if (newFile.isDirectory() && Configurator.getPreventRecursion()) {
                this.notAdded.add(Messages.getString("WalkerThread.0") + newFile);
                continue;
            }
            if (newFile.isDirectory()) {
                MyFile[] f_recurse = JUpload.convertToMyfiles(newFile.listFiles(), this.m_currentDirectory);
                this.notAdded.addAll(this.walkFileTree(f_recurse));
                continue;
            }
            try {
                ImageingUtilities.convertImage(newFile, this.myStatus);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (NoClassDefFoundError clerr) {
                System.err.println("Not converted, no Java 1.4 found:" + newFile);
            }
            catch (Error er) {
                this.notAdded.add("Out of memory: " + newFile);
            }
            if (Configurator.getResizeWithMetadata()) {
                try {
                    ImageingUtilities.resizeWithMetadata(newFile);
                }
                catch (NoClassDefFoundError error) {
                    error.printStackTrace();
                    System.err.println("Do you have Java 1.4?");
                }
            }
            if (null != this.m_jfc && null != this.m_jfc.getFileFilter() && null != newFile && !this.m_jfc.getFileFilter().accept(newFile)) {
                this.notAdded.add(Messages.getString("WalkerThread.filefilter.prefix") + t_files[i]);
                continue;
            }
            newFile.setCurrentDirectory(this.m_currentDirectory);
            if (this.m_parent.getQueueSelectedFiles().getListModel().size() >= Configurator.getMaxNumberFiles() && Configurator.getMaxNumberFiles() != -1) {
                this.notAdded.add(Messages.getString("WalkerThread.1") + newFile);
                continue;
            }
            if (!newFile.exists()) {
                this.notAdded.add(Messages.getString("WalkerThread.4") + newFile);
                continue;
            }
            if (newFile.length() > Configurator.getMaxFreeSpaceOnServer() && Configurator.getMaxFreeSpaceOnServer() != -1L) {
                this.notAdded.add(Messages.getString("WalkerThread.2") + newFile);
                continue;
            }
            if (newFile.length() > Configurator.getMaxTotalRequestSize() && Configurator.getMaxTotalRequestSize() != -1L) {
                this.notAdded.add(Messages.getString("WalkerThread.3") + newFile);
                continue;
            }
            Debug.println(this, "adding to queue: " + newFile);
            try {
                String jsErrorMessage = this.notifyJavaScriptAddListener(newFile);
                if (jsErrorMessage == null) {
                    this.m_parent.getQueueSelectedFiles().addFile(newFile);
                    continue;
                }
                this.notAdded.add(jsErrorMessage + ":" + newFile);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.notAdded.add(e.getMessage() + ":" + newFile);
            }
        }
        return this.notAdded;
    }

    private String notifyJavaScriptAddListener(MyFile newFile) {
        if (!this.m_applet.javascriptAddListenerRegistered) {
            return null;
        }
        JSObject win = this.m_applet.jsBrowserWindow;
        if (win == null) {
            return null;
        }
        Object rc = win.call(this.m_applet.javascriptAddListenerName, newFile.getName(), new Long(newFile.length()), newFile.getAbsolutePath(), newFile.getCurrentDirectory(), newFile.getMD5Hash(), newFile.getRelativeFilename(), newFile.getVirtualFilename(), newFile.getVirtualRelativePathname(), new Long(newFile.lastModified()));
        if (rc == null) {
            return null;
        }
        if (!(rc instanceof String)) {
            return null;
        }
        String str = (String)rc;
        if (str.equals("")) {
            return null;
        }
        if (str.equals("undefined")) {
            return null;
        }
        return str;
    }

    public static WalkerThread getInstance() {
        if (null == M_instance) {
            Debug.println(null, "Creating new walker thread M_instance.");
            M_instance = new WalkerThread();
        }
        return M_instance;
    }

    public void addFiles(MyFile[] t_files) {
        JSObject win;
        long startTime = System.currentTimeMillis();
        this.myStatus = UploadStatus.getInstance();
        if (this.myStatus.isRunning()) {
            this.myStatus = null;
        } else {
            if (this.m_parent == null || this.m_parent.statuspanel == null) {
                return;
            }
            this.m_parent.statuspanel.add(this.myStatus);
            this.myStatus.setProgressbarVisible(true);
            this.myStatus.start();
        }
        Debug.println(this, "WalkerThread() will add " + t_files.length + " initial files");
        Collection a_arrRejectedFiles = this.walkFileTree(t_files);
        this.m_parent.getQueueSelectedFiles().notifyListenersChanged();
        if (this.m_applet.javascriptAddedListenerRegistered && (win = this.m_applet.jsBrowserWindow) != null) {
            win.call(this.m_applet.javascriptAddedListenerName, null);
        }
        if (this.myStatus != null) {
            this.myStatus.stop();
            this.myStatus.setProgressbarVisible(false);
            this.myStatus.setMessage("");
            this.myStatus.setFilename("");
            this.myStatus.setTotalProgressbarVisible(false);
            this.m_parent.statuspanel.remove(this.myStatus);
            this.m_parent.statuspanel.validate();
        }
        if (!a_arrRejectedFiles.isEmpty() && Configurator.getShowErrorsOnAdd()) {
            Debug.println(this, Messages.getString("WalkerThread.5"));
            JList<Object> list = new JList<Object>(a_arrRejectedFiles.toArray());
            list.setVisibleRowCount(10);
            JScrollPane scroller = new JScrollPane(list);
            scroller.setPreferredSize(new Dimension(400, 300));
            Object[] objects = new Object[]{new String(Messages.getString("WalkerThread.6")), scroller};
            JOptionPane.showConfirmDialog(this.m_applet, objects, Messages.getString("WalkerThread.7"), -1);
        }
        JUpload.getInstance().statpanel.updateModel(JUpload.getInstance().getQueueSelectedFiles().getListModel());
        JUpload.getInstance().statpanel.doResize();
        long endTime = System.currentTimeMillis();
        Debug.println(this, "addFiles " + (endTime - startTime) + "ms");
    }

    public void setCurrentDirectory(File currentDir) {
        this.m_currentDirectory = currentDir;
    }

    public void setJFC(JFileChooser t_jfc) {
        this.m_jfc = t_jfc;
    }

    public void destroy() {
        Debug.println(this, "WalkerThread() thread is being destroyed.");
    }

    public static void kill() {
        M_instance = null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }
}

