/*
 * Decompiled with CFR 0.152.
 */
package JUpload.plugin;

import JUpload.plugin.IConnectionTrackerPlugin;
import JUpload.plugin.IHttpInputStreamPlugin;
import JUpload.plugin.IHttpOutputStreamPlugin;
import JUpload.plugin.IPlugin;
import JUpload.plugin.PluginException;
import JUpload.utilities.Debug;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PluginManager {
    private static PluginManager m_Self = null;
    private HashMap m_hmPlugins = new HashMap();
    private List m_listHttpOutputStreamPlugins = new ArrayList();
    private List m_listHttpInputStreamPlugins = new ArrayList();
    private List m_listConnectionTrackerPlugins = new ArrayList();

    private PluginManager() {
    }

    public static synchronized PluginManager getInstance() {
        if (null == m_Self) {
            m_Self = new PluginManager();
        }
        return m_Self;
    }

    private int i_getInsertPosition(List t_List, IPlugin t_Plugin) {
        int a_iListSize = t_List.size();
        if (0 == a_iListSize) {
            return 0;
        }
        int a_iPriority = t_Plugin.getPluginPriority();
        for (int i = 0; i < a_iListSize; ++i) {
            IPlugin a_RegisteredPlugin = (IPlugin)t_List.get(i);
            if (a_iPriority >= a_RegisteredPlugin.getPluginPriority()) continue;
            return i;
        }
        return a_iListSize;
    }

    public synchronized boolean registerPlugin(IPlugin t_Plugin) {
        Object a_oldPlugin;
        if (null != t_Plugin && null == (a_oldPlugin = this.m_hmPlugins.get(t_Plugin))) {
            int a_iInsertPosition;
            this.m_hmPlugins.put(t_Plugin, t_Plugin);
            if (t_Plugin instanceof IHttpOutputStreamPlugin) {
                a_iInsertPosition = this.i_getInsertPosition(this.m_listHttpOutputStreamPlugins, t_Plugin);
                this.m_listHttpOutputStreamPlugins.add(a_iInsertPosition, t_Plugin);
            }
            if (t_Plugin instanceof IHttpInputStreamPlugin) {
                a_iInsertPosition = this.i_getInsertPosition(this.m_listHttpInputStreamPlugins, t_Plugin);
                this.m_listHttpInputStreamPlugins.add(a_iInsertPosition, t_Plugin);
            }
            if (t_Plugin instanceof IConnectionTrackerPlugin) {
                a_iInsertPosition = this.i_getInsertPosition(this.m_listConnectionTrackerPlugins, t_Plugin);
                this.m_listConnectionTrackerPlugins.add(a_iInsertPosition, t_Plugin);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean unregisterPlugin(IPlugin t_Plugin) {
        IPlugin a_Plugin;
        if (null != t_Plugin && null != (a_Plugin = (IPlugin)this.m_hmPlugins.remove(t_Plugin))) {
            this.m_listHttpOutputStreamPlugins.remove(a_Plugin);
            this.m_listHttpInputStreamPlugins.remove(a_Plugin);
            this.m_listConnectionTrackerPlugins.remove(a_Plugin);
            return true;
        }
        return false;
    }

    public OutputStream hookOutputStream(OutputStream t_OutputStream) {
        OutputStream r_OutputStream = t_OutputStream;
        try {
            Iterator iter = this.m_listHttpOutputStreamPlugins.iterator();
            while (iter.hasNext()) {
                IHttpOutputStreamPlugin a_Plugin = (IHttpOutputStreamPlugin)iter.next();
                r_OutputStream = a_Plugin.hookOutputStream(r_OutputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r_OutputStream;
    }

    public InputStream hookInputStream(InputStream t_InputStream) {
        InputStream r_InputStream = t_InputStream;
        try {
            Iterator iter = this.m_listHttpInputStreamPlugins.iterator();
            while (iter.hasNext()) {
                IHttpInputStreamPlugin a_Plugin = (IHttpInputStreamPlugin)iter.next();
                r_InputStream = a_Plugin.hookInputStream(r_InputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r_InputStream;
    }

    public synchronized boolean hookTrackConnectionBegin(URL t_URL, String t_strUserName) {
        boolean r_Result = true;
        try {
            Iterator iter = this.m_listConnectionTrackerPlugins.iterator();
            while (iter.hasNext()) {
                IConnectionTrackerPlugin a_Plugin = (IConnectionTrackerPlugin)iter.next();
                try {
                    r_Result &= a_Plugin.trackConnectionBegin(t_URL, t_strUserName);
                }
                catch (PluginException pe) {
                    pe.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r_Result;
    }

    public synchronized void hookTrackConnectionEnd(URL t_URL, String t_strUserName) {
        try {
            Iterator iter = this.m_listConnectionTrackerPlugins.iterator();
            while (iter.hasNext()) {
                IConnectionTrackerPlugin a_Plugin = (IConnectionTrackerPlugin)iter.next();
                try {
                    a_Plugin.trackConnectionEnd(t_URL, t_strUserName);
                }
                catch (PluginException pe) {
                    pe.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean hookTrackTransmission(String t_strUserName, String t_strFileName, long t_tsFileLastModified, long t_lFileSize) {
        boolean r_Result = true;
        try {
            Iterator iter = this.m_listConnectionTrackerPlugins.iterator();
            while (iter.hasNext()) {
                IConnectionTrackerPlugin a_Plugin = (IConnectionTrackerPlugin)iter.next();
                try {
                    r_Result &= a_Plugin.trackTransmission(t_strUserName, t_strFileName, t_tsFileLastModified, t_lFileSize);
                }
                catch (PluginException pe) {
                    pe.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r_Result;
    }

    public synchronized void loadPlugins(String t_strPluginClassNames) {
        if (t_strPluginClassNames == null) {
            return;
        }
        StringTokenizer a_strtok = new StringTokenizer(t_strPluginClassNames, ";,:");
        while (a_strtok.hasMoreTokens()) {
            String a_strPluginClassName = a_strtok.nextToken();
            if (null == a_strPluginClassName) continue;
            try {
                boolean rc;
                IPlugin a_Plugin;
                Class<?> a_PluginClass = Class.forName(a_strPluginClassName);
                if (null == a_PluginClass || null == (a_Plugin = (IPlugin)a_PluginClass.newInstance()) || !(rc = a_Plugin.init()) || (rc = this.registerPlugin(a_Plugin))) continue;
                Debug.println(this, "loadPlugins(" + a_strPluginClassName + "): plugin already registered");
            }
            catch (Exception e) {
                Debug.println(this, "loadPlugins(" + a_strPluginClassName + "): failed to load class or create instance");
                e.printStackTrace();
            }
        }
    }

    public int queryNumberOfPlugins() {
        return this.m_hmPlugins.size();
    }

    public synchronized void removeAllPlugins() {
        this.m_hmPlugins.clear();
        this.m_listHttpInputStreamPlugins.clear();
        this.m_listHttpOutputStreamPlugins.clear();
        this.m_listConnectionTrackerPlugins.clear();
    }
}

