/*
 * Decompiled with CFR 0.152.
 */
package JUpload.http;

import JUpload.gui.UploadStatus;
import JUpload.http.HTTPRequest;
import JUpload.security.PGPEncryptedOutputStream;
import JUpload.swingVersion.JUpload;
import JUpload.swingVersion.UploadJob;
import JUpload.utilities.Configurator;
import JUpload.utilities.MyFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

public class PgpEncryptedRequest
implements HTTPRequest {
    private final Vector uploadJobs;
    private final JUpload parent;
    private URL actionURL;
    private URL publicKeyURL;
    private UploadStatus status;
    private boolean running = false;
    private boolean finished = false;
    private int maxRetries;

    public PgpEncryptedRequest(JUpload parent, Vector uploadJobs) {
        this.parent = parent;
        this.uploadJobs = uploadJobs;
        this.status = UploadStatus.getInstance();
    }

    public void setActionURL(URL url) {
        this.actionURL = url;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setLastRequest(boolean status) {
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stopUpload() {
        this.running = false;
    }

    public void run() {
        this.running = true;
        this.status.start();
        try {
            this.publicKeyURL = Configurator.getEncryptPublicKeyURL();
            Iterator jobIter = this.uploadJobs.iterator();
            while (jobIter.hasNext()) {
                UploadJob job = (UploadJob)jobIter.next();
                Iterator fileIter = job.getFiles().iterator();
                while (fileIter.hasNext()) {
                    this.parent.validate();
                    MyFile file = (MyFile)fileIter.next();
                    this.processFile(file);
                    if (this.isRunning()) continue;
                    break;
                }
                if (this.isRunning()) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isRunning()) {
            this.parent.getQueueSelectedFiles().removeUploadedFiles();
        }
        this.finished = true;
        this.running = false;
        this.status.stop();
    }

    private void processFile(MyFile file) throws Exception, FileNotFoundException, IOException {
        PGPEncryptedOutputStream pgp = new PGPEncryptedOutputStream(this.status, file, this.publicKeyURL, this.actionURL);
        FileInputStream fis = new FileInputStream(file);
        while (fis.available() > 0) {
            int chunkSize = Math.min(fis.available(), 65536);
            byte[] buf = new byte[chunkSize];
            fis.read(buf);
            pgp.write(buf);
            pgp.flush();
            if (this.isRunning()) continue;
            break;
        }
        pgp.close();
        fis.close();
        this.status.setFilename("");
        if (this.isRunning()) {
            file.setUploaded(true);
        } else {
            file.setFailure(true);
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

