<?php
/**
 * Holds configuration data for all available Form Designs
 */

return array(
	'ribbon'        => array(
		'blank_set' => array(
			'name' => 'Blank Ribbon',
			'css'  => 'blank_set.css'
		),
		'one_set'   => array(
			'name'  => 'Ribbon Set 001',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
		),
		'two_set'   => array(
			'name'  => 'Ribbon Set 002',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
		),
		'three_set' => array(
			'name'  => 'Ribbon Set 003',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'four_set'  => array(
			'name'  => 'Ribbon Set 004',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			),
		),
		'five_set'  => array(
			'name'  => 'Ribbon set 005',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			),
		),
		'six_set'   => array(
			'name'  => 'Ribbon set 006',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			),
		),
		'seven_set' => array(
			'name'  => 'Ribbon set 007',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			),
		),
		'eight_set' => array(
			'name'  => 'Ribbon set 008',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			),
		),
	),
	'lightbox'      => array(
		'blank_set'            => array(
			'name' => 'Blank Lightbox',
			'css'  => 'blank_set.css'
		),
		'one_set_v1'           => array(
			'name'  => 'Lightbox Set 001 v1',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'one_set_v2'           => array(
			'name'  => 'Lightbox Set 001 v2',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'two_set_v1'           => array(
			'name'  => 'Lightbox Set 002 v1',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
			'icons' => array(
				'two-set-lock'
			)
		),
		'two_set_v2'           => array(
			'name'  => 'Lightbox Set 002 v2',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			)
		),
		'two_set_v3'           => array(
			'name'  => 'Lightbox Set 002 v3',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			)
		),
		'two_set_v4'           => array(
			'name'                  => 'Lightbox Set 002 v4',
			'css'                   => 'two_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set2_lightbox4_bg.jpg'
			)
		),
		'two_set_v5'           => array(
			'name'                  => 'Lightbox Set 002 v5',
			'css'                   => 'two_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set2_lightbox4_bg.jpg'
			)
		),
		'two_set_v6'           => array(
			'name'  => 'Lightbox Set 002 v6',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			)
		),
		'three_set_v1'         => array(
			'name'  => 'Lightbox Set 003 v1',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'three_set_v2'         => array(
			'name'  => 'Lightbox Set 003 v2',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'four_set_v1'          => array(
			'name'                  => 'Lightbox Set 004 v1',
			'css'                   => 'four_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set4_lightbox_bg.jpg'
			)
		),
		'four_set_v2'          => array(
			'name'                  => 'Lightbox Set 004 v2',
			'css'                   => 'four_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set4_lightbox_bg.jpg'
			)
		),
		'five_set_v1'          => array(
			'name'                  => 'Lightbox Set 005 v1',
			'css'                   => 'five_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set_five_pattern.jpg'
			)
		),
		'five_set_v2'          => array(
			'name'  => 'Lightbox Set 005 v2',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			)
		),
		'six_set_v1'           => array(
			'name'  => 'Lightbox Set 006 v1',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			)
		),
		'six_set_v2'           => array(
			'name'  => 'Lightbox Set 006 v2',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			)
		),
		'seven_set_v1'         => array(
			'name'  => 'Lightbox Set 007 v1',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
			)
		),
		'seven_set_v2'         => array(
			'name'  => 'Lightbox Set 007 v2',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
			)
		),
		'seven_set_v3'         => array(
			'name'                  => 'Lightbox Set 007 v3',
			'css'                   => 'seven_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set_seven_lightbox_bg.png'
			)
		),
		'eight_set_v1'         => array(
			'name'  => 'Lightbox Set 008 v1',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			),
			'icons' => array(
				'eight-set-icon-user',
				'eight-set-icon-email'
			)
		),
		'eight_set_v2'         => array(
			'name'  => 'Lightbox Set 008 v2',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			)
		),
		'one_set_vms_step1'    => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 001',
			'css'        => 'one_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'one_set_vms_step2'    => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 001',
			'css'        => 'one_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'two_set_vms_step1'    => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 002',
			'css'        => 'two_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			)
		),
		'two_set_vms_step2'    => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 002',
			'css'        => 'two_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
			'icons'      => array(
				'two-set-user',
				'two-set-envelope'
			)
		),
		'eight_set_vms_step1'  => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 008',
			'css'        => 'eight_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			)
		),
		'eight_set_vms_step2'  => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 008',
			'css'        => 'eight_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
				'//fonts.googleapis.com/css?family=Lato:400'
			),
			'icons'      => array(
				'two-set-user',
				'two-set-envelope'
			)
		),
		'nine_set_vms_step1'   => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 009',
			'css'        => 'nine_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
				'//fonts.googleapis.com/css?family=Lato:300,400'
			)
		),
		'nine_set_vms_step2'   => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 009',
			'css'        => 'nine_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			)
		),
		'ten_set_vms_step1'    => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 010',
			'css'        => 'ten_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600'
			)
		),
		'ten_set_vms_step2'    => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 010',
			'css'        => 'ten_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600',
				'//fonts.googleapis.com/css?family=Roboto:300',
			),
			'icons'      => array(
				'ten-set-mail'
			)
		),
		'eleven_set_vms_step1' => array(
			'multi_step'            => true,
			'name'                  => 'Lightbox Set 011',
			'css'                   => 'eleven_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			'icons'                 => array(
				'eleven-set-icon-beginner',
				'eleven-set-icon-advanced'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/eleven_set_bg.png'
			)
		),
		'eleven_set_vms_step2' => array(
			'multi_step'            => true,
			'name'                  => 'Lightbox Set 011',
			'css'                   => 'eleven_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/eleven_set_bg.png'
			)
		),
		'eleven_set_vms_step3' => array(
			'multi_step'            => true,
			'name'                  => 'Lightbox Set 011',
			'css'                   => 'eleven_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/eleven_set_bg.png'
			)
		),
		'twelve_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step3' => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step4' => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'20_set'               => array(
			'name'  => 'Lightbox Set 020',
			'css'   => '20_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'21_set'               => array(
			'name'  => 'Lightbox Set 021',
			'css'   => '21_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-21-icon-mail'
			)
		),
		'22_set'               => array(
			'name'  => 'Lightbox Set 022',
			'css'   => '22_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'23_set'               => array(
			'name'  => 'Lightbox Set 023',
			'css'   => '23_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'24_set'               => array(
			'name'  => 'Lightbox Set 024',
			'css'   => '24_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'25_set'               => array(
			'name'  => 'Lightbox Set 025',
			'css'   => '25_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'26_set'               => array(
			'name'  => 'Lightbox Set 026',
			'css'   => '26_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'27_set'               => array(
			'name'  => 'Lightbox Set 027',
			'css'   => '27_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'28_set'               => array(
			'name'  => 'Lightbox Set 028',
			'css'   => '28_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'29_set'               => array(
			'name'  => 'Lightbox Set 029',
			'css'   => '29_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-29-icon-mail'
			)
		),
		'30_set'               => array(
			'name'  => 'Lightbox Set 030',
			'css'   => '30_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'31_set'               => array(
			'name'  => 'Lightbox Set 031',
			'css'   => '31_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'32_set'               => array(
			'name'  => 'Lightbox Set 032',
			'css'   => '32_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'33_set'               => array(
			'name'  => 'Lightbox Set 033',
			'css'   => '33_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'34_set'               => array(
			'name'  => 'Lightbox Set 034',
			'css'   => '34_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'35_set'               => array(
			'name'  => 'Lightbox Set 035',
			'css'   => '35_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'36_set'               => array(
			'name'  => 'Lightbox Set 036',
			'css'   => '36_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'37_set'               => array(
			'name'  => 'Lightbox Set 037',
			'css'   => '37_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'38_set'               => array(
			'name'  => 'Lightbox Set 038',
			'css'   => '38_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700,700italic,500italic'
			),
		),
		'39_set'               => array(
			'name'  => 'Lightbox Set 039',
			'css'   => '39_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
			),
		),
		'40_set'               => array(
			'name'  => 'Lightbox Set 040',
			'css'   => '40_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'41_set'               => array(
			'name'  => 'Lightbox Set 041',
			'css'   => '41_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'42_set'               => array(
			'name'  => 'Lightbox Set 042',
			'css'   => '42_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'43_set'               => array(
			'name'  => 'Lightbox Set 043',
			'css'   => '43_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'44_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'44_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'46_set_vms_step1'     => array(
			'multi_step'            => true,
			'name'                  => 'Lightbox Set 046',
			'css'                   => '46_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/46_set_bg.png'
			)
		),
		'46_set_vms_step2'     => array(
			'multi_step'            => true,
			'name'                  => 'Lightbox Set 046',
			'css'                   => '46_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cimg' => TVE_LEADS_URL . 'editor-templates/_form_css/images/46_set_bg.png'
			)
		),
		'47_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'47_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'48_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'48_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'50_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'50_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'51_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 051',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'51_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 051',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'52_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'set-52-icon'
			)
		),
		'52_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'53_set_vms_step1'     => array(
			'multi_step'            => true,
			'name'                  => 'Lightbox Set 053',
			'css'                   => '53_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cpat' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set_53_pattern.jpg'
			)
		),
		'53_set_vms_step2'     => array(
			'multi_step'            => true,
			'name'                  => 'Lightbox Set 053',
			'css'                   => '53_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			TVE_LEADS_FIELD_GLOBALS => array(
				'l_cpat' => TVE_LEADS_URL . 'editor-templates/_form_css/images/set_53_pattern.jpg'
			)
		),
		'54_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 054',
			'css'        => '54_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,100,300,500,700'
			)
		),
		'55_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 055',
			'css'        => '55_set.css'
		),
		'56_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 056',
			'css'        => '56_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,100,300,500,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			)
		),
		'57_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 057',
			'css'        => '57_set.css'
		),
		'58_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 058',
			'css'        => '58_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,300,700'
			),
			'icons'      => array(
				'set-58-arrow'
			)
		),
		'59_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Lightbox Set 059',
			'css'        => '59_set.css'
		),
	),
	'widget'        => array(
		'blank_set'    => array(
			'name' => 'Blank Widget',
			'css'  => 'blank_set.css'
		),
		'one_set'      => array(
			'name'  => 'Widget Set 001',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'two_set_v1'   => array(
			'name'         => 'Widget Set 002 v1',
			'css'          => 'two_set.css',
			'fonts'        => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
			'element_menu' => array(
				'hide_default_colors' => false
			)
		),
		'two_set_v2'   => array(
			'name'         => 'Widget Set 002 v2',
			'css'          => 'two_set.css',
			'fonts'        => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
			'element_menu' => array(
				'hide_default_colors' => false
			),
			'icons'        => array(
				'two-set-mail'
			)
		),
		'two_set_v3'   => array(
			'name'  => 'Widget Set 002 v3',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
			),
			'icons' => array(
				'two-set-airplane'
			)
		),
		'three_set'    => array(
			'name'  => 'Widget Set 003',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'four_set'     => array(
			'name'  => 'Widget Set 004',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			)
		),
		'five_set'     => array(
			'name'  => 'Widget Set 005',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			)
		),
		'six_set'      => array(
			'name'  => 'Widget Set 006',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			)
		),
		'seven_set_v1' => array(
			'name'  => 'Widget Set 007 v1',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',

			),
		),
		'seven_set_v2' => array(
			'name'  => 'Widget Set 007 v2',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
			)
		),
		'eight_set'    => array(
			'name'  => 'Widget Set 008',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			),
			'icons' => array(
				'eight-set-icon-email'
			)
		),
		'20_set'       => array(
			'name'  => 'Widget Set 020',
			'css'   => '20_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'21_set'       => array(
			'name'  => 'Widget Set 021',
			'css'   => '21_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-21-icon-mail'
			)
		),
		'22_set'       => array(
			'name'  => 'Widget Set 022',
			'css'   => '22_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'23_set'       => array(
			'name'  => 'Widget Set 023',
			'css'   => '23_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'24_set'       => array(
			'name'  => 'Widget Set 024',
			'css'   => '24_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'25_set'       => array(
			'name'  => 'Widget Set 025',
			'css'   => '25_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'26_set'       => array(
			'name'  => 'Widget Set 026',
			'css'   => '26_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'27_set'       => array(
			'name'  => 'Widget Set 027',
			'css'   => '27_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'28_set'       => array(
			'name'  => 'Widget Set 028',
			'css'   => '28_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'29_set'       => array(
			'name'  => 'Widget Set 029',
			'css'   => '29_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-29-icon-mail'
			)
		),
		'30_set'       => array(
			'name'  => 'Widget Set 030',
			'css'   => '30_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'31_set'       => array(
			'name'  => 'Widget Set 031',
			'css'   => '31_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'32_set'       => array(
			'name'  => 'Widget Set 032',
			'css'   => '32_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'33_set'       => array(
			'name'  => 'Widget Set 033',
			'css'   => '33_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'34_set'       => array(
			'name'  => 'Widget Set 034',
			'css'   => '34_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'35_set'       => array(
			'name'  => 'Widget Set 035',
			'css'   => '35_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'36_set'       => array(
			'name'  => 'Widget Set 036',
			'css'   => '36_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'37_set'       => array(
			'name'  => 'Widget Set 037',
			'css'   => '37_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'38_set'       => array(
			'name'  => 'Widget Set 038',
			'css'   => '38_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700,700italic,500italic'
			),
		),
		'39_set'       => array(
			'name'  => 'Widget Set 039',
			'css'   => '39_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
			),
		),
		'40_set'       => array(
			'name'  => 'Widget Set 040',
			'css'   => '40_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'41_set'       => array(
			'name'  => 'Widget Set 041',
			'css'   => '41_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'42_set'       => array(
			'name'  => 'Widget Set 042',
			'css'   => '42_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'43_set'       => array(
			'name'  => 'Widget Set 043',
			'css'   => '43_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
	),
	'greedy_ribbon' => array(
		'blank_set'                => array(
			'name' => 'Blank Scroll Mat',
			'css'  => 'blank_set.css'
		),
		'gr_one_set'               => array(
			'name'  => 'Scroll Mat set 001',
			'css'   => 'gr_one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Oswald:400,300,700',
				'//fonts.googleapis.com/css?family=Merriweather:400,700,300'
			),
			'icons' => array(
				'gr-one-set-close'
			)
		),
		'gr_two_set'               => array(
			'name'  => 'Scroll Mat set 002',
			'css'   => 'gr_two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,800'
			),
			'icons' => array(
				'gr-two-set-close'
			)
		),
		'gr_three_set'             => array(
			'name'  => 'Scroll Mat set 003',
			'css'   => 'gr_three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,700'
			),
			'icons' => array(
				'gr-three-set-close'
			)
		),
		'gr_four_set_vms_step1'    => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 004 v1',
			'css'        => 'gr_four_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'gr-four-set-close'
			)
		),
		'gr_four_set_vms_step2'    => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 004 v1',
			'css'        => 'gr_four_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'gr-four-set-close'
			)
		),
		'gr_four_set_vms_step1_v2' => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 004 v2',
			'css'        => 'gr_four_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'gr-four-set-close'
			)
		),
		'gr_four_set_vms_step2_v2' => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 004 v2',
			'css'        => 'gr_four_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'gr-four-set-close'
			)
		),
		'gr_five_set_vms_step1'    => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 005',
			'css'        => 'gr_five_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Allan:400,700'
			),
			'icons'      => array(
				'gr-five-set-close'
			)
		),
		'gr_five_set_vms_step2'    => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 005',
			'css'        => 'gr_five_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Allan:400,700'
			),
			'icons'      => array(
				'gr-five-set-close'
			)
		),
		'gr_six_set_vms_step1'     => array(
			'multi_step'            => true,
			'name'                  => 'Scroll Mat set 006',
			'css'                   => 'gr_six_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Courgette'
			),
			'icons'                 => array(
				'gr-six-set-close'
			),
			'custom_color_mappings' => array(
				'contentbox' => array(
					'5s' => array(
						'Flat' => array(
							array(
								"label"    => "Bubble Border Color",
								'opacity'  => 1,
								"selector" => ".tve_cb5",
								"property" => "color",
								"value"    => "[color]"
							),
						)
					),
				)
			)
		),
		'gr_six_set_vms_step2'     => array(
			'multi_step'            => true,
			'name'                  => 'Scroll Mat set 006',
			'css'                   => 'gr_six_set.css',
			'fonts'                 => array(
				'//fonts.googleapis.com/css?family=Courgette'
			),
			'icons'                 => array(
				'gr-six-set-close'
			),
			'custom_color_mappings' => array(
				'contentbox' => array(
					'5s' => array(
						'Flat' => array(
							array(
								"label"    => "Bubble Border Color",
								'opacity'  => 1,
								"selector" => ".tve_cb5",
								"property" => "color",
								"value"    => "[color]"
							),
						)
					),
				)
			)
		),
		'gr_seven_set_vms_step1'   => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 007',
			'css'        => 'gr_seven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			),
			'icons'      => array(
				'gr-seven-set-close'
			)
		),
		'gr_seven_set_vms_step2'   => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 007',
			'css'        => 'gr_seven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			),
			'icons'      => array(
				'gr-seven-set-close'
			)
		),
		'gr_eight_set_vms_step1'   => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 008',
			'css'        => 'gr_eight_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Slab:300,400,100',
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			),
			'icons'      => array(
				'gr-eight-set-close'
			)
		),
		'gr_eight_set_vms_step2'   => array(
			'multi_step' => true,
			'name'       => 'Scroll Mat set 008',
			'css'        => 'gr_eight_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Slab:300,400,100',
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			),
			'icons'      => array(
				'gr-eight-set-close'
			)
		),
		'gr_nine_set'              => array(
			'name'  => 'Scroll Mat set 009',
			'css'   => 'gr_nine_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
			'icons' => array(
				'gr-nine-set-mail'
			)
		),
		'gr_ten_set'               => array(
			'name'  => 'Scroll Mat set 010',
			'css'   => 'gr_ten_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Raleway:400,700,300'
			),
			'icons' => array(
				'gr-nine-set-mail'
			)
		),
		/*'gr_four_set' => array(
            'name' => 'Scroll Mat set 004',
            'css' => 'gr_four_set.css',
            'fonts' => array(
                '//fonts.googleapis.com/css?family=Roboto:400,300,700,300italic'
            ),
            'icons' => array(
                'gr-four-set-close', 'gr-four-set-mail' .
            )
        ),
        'gr_five_set' => array(
            'name' => 'Scroll Mat set 005',
            'css' => 'gr_five_set.css',
            'fonts' => array(
                '//fonts.googleapis.com/css?family=Montserrat:400,700'
            )
        ),*/
	),
	'screen_filler' => array(
		'blank_set'              => array(
			'name' => 'Blank Screen filler',
			'css'  => 'blank_set.css'
		),
		'two_set_v1'             => array(
			'name'  => 'Screen filler Set 002 v1',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
			'icons' => array(
				'two-set-user',
				'two-set-envelope'
			)
		),
		'two_set_v2'             => array(
			'name'  => 'Screen filler Set 002 v2',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
			'icons' => array(
				'two-set-user',
				'two-set-envelope'
			)
		),
		'two_set_v3'             => array(
			'name'  => 'Screen filler Set 002 v3',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
			'icons' => array(
				'two-set-user',
				'two-set-envelope'
			)
		),
		'three_set_v1'           => array(
			'name'  => 'Screen filler Set 003 v1',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'three_set_v2'           => array(
			'name'  => 'Screen filler Set 003 v2',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'three-set-mail'
			)
		),
		'three_set_v3'           => array(
			'name'  => 'Screen filler Set 003 v3',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'seven_set'              => array(
			'name'  => 'Screen filler Set 007',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
			)
		),
		'thirteen_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 013',
			'css'        => 'thirteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
			'icons'      => array(
				'thirteen-set-icon-file',
				'thirteen-set-icon-arrow',
				'thrirteen-set-icon-check',
				'thrirteen-set-icon-reject'
			),
		),
		'thirteen_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 013',
			'css'        => 'thirteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
			'icons'      => array(
				'thirteen-set-icon-file',
				'thirteen-set-icon-arrow'
			),
		),
		'fourteen_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 014',
			'css'        => 'fourteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Condensed:400,300,700,500',
				'//fonts.googleapis.com/css?family=Roboto:500,300,500italic'
			),
		),
		'fourteen_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 014',
			'css'        => 'fourteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Condensed:400,300,700,500',
				'//fonts.googleapis.com/css?family=Roboto:500,300,500italic'
			),
		),
		'fifteen_set_vms_step1'  => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 015',
			'css'        => 'fifteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Slab:300,400,100',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
			'icons'      => array(
				'fifteen-set-icon-sixpack',
				'fifteen-set-icon-burnfat',
				'fifteen-set-icon-getstrong'
			)
		),
		'fifteen_set_vms_step2'  => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 015',
			'css'        => 'fifteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Slab:300,400,100',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
			'icons'      => array(
				'fifteen-set-icon-sixpack',
				'fifteen-set-icon-burnfat',
				'fifteen-set-icon-getstrong'
			)
		),
		'fifteen_set_vms_step3'  => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 015',
			'css'        => 'fifteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Slab:300,400,100',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
			'icons'      => array(
				'fifteen-set-icon-sixpack',
				'fifteen-set-icon-burnfat',
				'fifteen-set-icon-getstrong'
			)
		),
		'fifteen_set_vms_step4'  => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 015',
			'css'        => 'fifteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto+Slab:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
			'icons'      => array(
				'fifteen-set-icon-sixpack',
				'fifteen-set-icon-burnfat',
				'fifteen-set-icon-getstrong'
			)
		),
		'sixteen_set'            => array(
			'name'  => 'Screen filler Set 016',
			'css'   => 'sixteen_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Condensed:400,300'
			),
		),
		'seventeen_set'          => array(
			'name'  => 'Screen filler Set 017',
			'css'   => 'seventeen_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans+Condensed:700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'eighteen_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 018',
			'css'        => 'eighteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'eighteen_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 018',
			'css'        => 'eighteen_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'nineteen_set'           => array(
			'name'  => 'Screen filler Set 019',
			'css'   => 'nineteen_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700,100',
			),
		),
		'44_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'44_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'46_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 046',
			'css'        => '46_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'46_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 046',
			'css'        => '46_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'47_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'47_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'48_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'48_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'50_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'50_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'51_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 051',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'51_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 051',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'52_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'set-52-icon'
			)
		),
		'52_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'53_set_vms_step1'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 053',
			'css'        => '53_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'53_set_vms_step2'       => array(
			'multi_step' => true,
			'name'       => 'Screen filler Set 053',
			'css'        => '53_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		)
	),
	'slide_in'      => array(
		'blank_set'    => array(
			'name' => 'Blank Slide in',
			'css'  => 'blank_set.css'
		),
		'one_set_v1'   => array(
			'name'  => 'Slide in Set 001 v1',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'one_set_v2'   => array(
			'name'  => 'Slide in Set 001 v2',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'two_set'      => array(
			'name'  => 'Slide in Set 002',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			)
		),
		'three_set'    => array(
			'name'  => 'Slide in Set 003',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'four_set_v1'  => array(
			'name'  => 'Slide in Set 004 v1',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			)
		),
		'four_set_v2'  => array(
			'name'  => 'Slide in Set 004 v2',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			)
		),
		'five_set'     => array(
			'name'  => 'Slide in Set 005',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			),
		),
		'six_set'      => array(
			'name'  => 'Slide in Set 006',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			),
		),
		'seven_set_v1' => array(
			'name'  => 'Slide in Set 007 v1',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
			),
		),
		'seven_set_v2' => array(
			'name'  => 'Slide in Set 007 v2',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
			),
		),
		'eight_set'    => array(
			'name'  => 'Slide in Set 008',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			),
			'icons' => array(
				'eight-set-icon-email'
			)
		),
	),
	'post_footer'   => array(
		'blank_set'            => array(
			'name' => 'Blank Post footer',
			'css'  => 'blank_set.css'
		),
		'one_set'              => array(
			'name'  => 'Post footer Set 001',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'two_set'              => array(
			'name'  => 'Post footer Set 002',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			)
		),
		'three_set_v1'         => array(
			'name'  => 'Post footer Set 003 v1',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'three_set_v2'         => array(
			'name'  => 'Post footer Set 003 v2',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'four_set'             => array(
			'name'  => 'Post footer Set 004',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			)
		),
		'five_set'             => array(
			'name'  => 'Post footer Set 005',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			)
		),
		'six_set'              => array(
			'name'  => 'Post footer Set 006',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			)
		),
		'seven_set_v1'         => array(
			'name'  => 'Post footer Set 007 v1',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			)
		),
		'seven_set_v2'         => array(
			'name'  => 'Post footer Set 007 v2',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			)
		),
		'eight_set'            => array(
			'name'  => 'Post footer Set 008',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			)
		),
		'nine_set_vms_step1'   => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 009',
			'css'        => 'nine_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
				'//fonts.googleapis.com/css?family=Lato:300,400'
			)
		),
		'nine_set_vms_step2'   => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 009',
			'css'        => 'nine_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			)
		),
		'ten_set_vms_step1'    => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 010',
			'css'        => 'ten_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600'
			)
		),
		'ten_set_vms_step2'    => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 010',
			'css'        => 'ten_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600',
				'//fonts.googleapis.com/css?family=Roboto:300',
			),
			'icons'      => array(
				'ten-set-mail'
			)
		),
		'eleven_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 011',
			'css'        => 'eleven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			'icons'      => array(
				'eleven-set-icon-beginner',
				'eleven-set-icon-advanced'
			),
		),
		'eleven_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 011',
			'css'        => 'eleven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
		),
		'eleven_set_vms_step3' => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 011',
			'css'        => 'eleven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
		),
		'twelve_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step3' => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step4' => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'20_set'               => array(
			'name'  => 'Post footer Set 020',
			'css'   => '20_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'21_set'               => array(
			'name'  => 'Post footer Set 021',
			'css'   => '21_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-21-icon-mail'
			)
		),
		'22_set'               => array(
			'name'  => 'Post footer Set 022',
			'css'   => '22_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'23_set'               => array(
			'name'  => 'Post footer Set 023',
			'css'   => '23_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'24_set'               => array(
			'name'  => 'Post footer Set 024',
			'css'   => '24_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'25_set'               => array(
			'name'  => 'Post footer Set 025',
			'css'   => '25_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'26_set'               => array(
			'name'  => 'Post footer Set 026',
			'css'   => '26_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'27_set'               => array(
			'name'  => 'Post footer Set 027',
			'css'   => '27_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'28_set'               => array(
			'name'  => 'Post footer Set 028',
			'css'   => '28_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'29_set'               => array(
			'name'  => 'Post footer Set 029',
			'css'   => '29_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-29-icon-mail'
			)
		),
		'30_set'               => array(
			'name'  => 'Post footer Set 030',
			'css'   => '30_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'31_set'               => array(
			'name'  => 'Post footer Set 031',
			'css'   => '31_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'32_set'               => array(
			'name'  => 'Post footer Set 032',
			'css'   => '32_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'33_set'               => array(
			'name'  => 'Post footer Set 033',
			'css'   => '33_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'34_set'               => array(
			'name'  => 'Post footer Set 034',
			'css'   => '34_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'35_set'               => array(
			'name'  => 'Post footer Set 035',
			'css'   => '35_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'36_set'               => array(
			'name'  => 'Post footer Set 036',
			'css'   => '36_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'37_set'               => array(
			'name'  => 'Post footer Set 037',
			'css'   => '37_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'38_set'               => array(
			'name'  => 'Post footer Set 038',
			'css'   => '38_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700,700italic,500italic'
			),
		),
		'39_set'               => array(
			'name'  => 'Post footer Set 039',
			'css'   => '39_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
			),
		),
		'40_set'               => array(
			'name'  => 'Post footer Set 040',
			'css'   => '40_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'41_set'               => array(
			'name'  => 'Post footer Set 041',
			'css'   => '41_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'42_set'               => array(
			'name'  => 'Post footer Set 042',
			'css'   => '42_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'43_set'               => array(
			'name'  => 'Post footer Set 043',
			'css'   => '43_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'44_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'44_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'46_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 046',
			'css'        => '46_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'46_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 046',
			'css'        => '46_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'47_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'47_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'48_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'48_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'50_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'50_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'51_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 051',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'51_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 51',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'52_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'set-52-icon'
			)
		),
		'52_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'53_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 052',
			'css'        => '53_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'53_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Post footer Set 53',
			'css'        => '53_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		)
	),
	'in_content'    => array(
		'blank_set'    => array(
			'name' => 'Blank In content',
			'css'  => 'blank_set.css'
		),
		'one_set'      => array(
			'name'  => 'In content Set 001',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'two_set'      => array(
			'name'  => 'In content Set 002',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			)
		),
		'three_set_v1' => array(
			'name'  => 'In content Set 003 v1',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'three_set_v2' => array(
			'name'  => 'In content Set 003 v2',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'four_set'     => array(
			'name'  => 'In content Set 004',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			)
		),
		'five_set'     => array(
			'name'  => 'In content Set 005',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			)
		),
		'six_set'      => array(
			'name'  => 'In content Set 006',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			)
		),
		'seven_set_v1' => array(
			'name'  => 'In content Set 007 v1',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			)
		),
		'seven_set_v2' => array(
			'name'  => 'In content Set 007 v2',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			)
		),
		'eight_set'    => array(
			'name'  => 'In content Set 008',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			)
		),
		'20_set'       => array(
			'name'  => 'In content Set 020',
			'css'   => '20_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'21_set'       => array(
			'name'  => 'In content Set 021',
			'css'   => '21_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-21-icon-mail'
			)
		),
		'22_set'       => array(
			'name'  => 'In content Set 022',
			'css'   => '22_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'23_set'       => array(
			'name'  => 'In content Set 023',
			'css'   => '23_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'24_set'       => array(
			'name'  => 'In content Set 024',
			'css'   => '24_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'25_set'       => array(
			'name'  => 'In content Set 025',
			'css'   => '25_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'26_set'       => array(
			'name'  => 'In content Set 026',
			'css'   => '26_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'27_set'       => array(
			'name'  => 'In content Set 027',
			'css'   => '27_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'28_set'       => array(
			'name'  => 'In content Set 028',
			'css'   => '28_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'29_set'       => array(
			'name'  => 'In content Set 029',
			'css'   => '29_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-29-icon-mail'
			)
		),
		'30_set'       => array(
			'name'  => 'In content Set 030',
			'css'   => '30_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'31_set'       => array(
			'name'  => 'In content Set 031',
			'css'   => '31_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'32_set'       => array(
			'name'  => 'In content Set 032',
			'css'   => '32_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'33_set'       => array(
			'name'  => 'In content Set 033',
			'css'   => '33_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'34_set'       => array(
			'name'  => 'In content Set 034',
			'css'   => '34_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'35_set'       => array(
			'name'  => 'In content Set 035',
			'css'   => '35_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'36_set'       => array(
			'name'  => 'In content Set 036',
			'css'   => '36_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'37_set'       => array(
			'name'  => 'In content Set 037',
			'css'   => '37_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'38_set'       => array(
			'name'  => 'In content Set 038',
			'css'   => '38_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700,700italic,500italic'
			),
		),
		'39_set'       => array(
			'name'  => 'In content Set 039',
			'css'   => '39_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
			),
		),
		'40_set'       => array(
			'name'  => 'In content Set 040',
			'css'   => '40_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'41_set'       => array(
			'name'  => 'In content Set 041',
			'css'   => '41_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'42_set'       => array(
			'name'  => 'In content Set 042',
			'css'   => '42_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'43_set'       => array(
			'name'  => 'In content Set 043',
			'css'   => '43_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
	),
	'shortcode'     => array(
		'blank_set'            => array(
			'name' => 'Blank Shortcode',
			'css'  => 'blank_set.css'
		),
		'one_set'              => array(
			'name'  => 'Shortcode Set 001',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'two_set'              => array(
			'name'  => 'Shortcode Set 002',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			)
		),
		'three_set_v1'         => array(
			'name'  => 'Shortcode Set 003 v1',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'three_set_v2'         => array(
			'name'  => 'Shortcode Set 003 v2',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			)
		),
		'four_set'             => array(
			'name'  => 'Shortcode Set 004',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			)
		),
		'five_set'             => array(
			'name'  => 'Shortcode Set 005',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			)
		),
		'six_set'              => array(
			'name'  => 'Shortcode Set 006',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			)
		),
		'seven_set_v1'         => array(
			'name'  => 'Shortcode Set 007 v1',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			)
		),
		'seven_set_v2'         => array(
			'name'  => 'Shortcode Set 007 v2',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			)
		),
		'eight_set'            => array(
			'name'  => 'Shortcode Set 008',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			)
		),
		'one_set_v2'           => array(
			'name'  => 'Content Locking Shortcode Set 001',
			'css'   => 'one_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			'icons' => array(
				'one-set-icon-lock'
			)
		),
		'two_set_v2'           => array(
			'name'  => 'Content Locking Shortcode Set 002',
			'css'   => 'two_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
			'icons' => array(
				'two-set-lock'
			)
		),
		'three_set_v3'         => array(
			'name'  => 'Content Locking Shortcode Set 003 v1',
			'css'   => 'three_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'three-set-icon-lock'
			)
		),
		'four_set_v2'          => array(
			'name'  => 'Content Locking Shortcode Set 004',
			'css'   => 'four_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Josefin+Sans:400,600',
				'//fonts.googleapis.com/css?family=Open+Sans',
				'//fonts.googleapis.com/css?family=Lato:400,700'
			),
			'icons' => array(
				'four-set-icon-lock'
			)
		),
		'five_set_v2'          => array(
			'name'  => 'Content Locking Shortcode Set 005',
			'css'   => 'five_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			),
			'icons' => array(
				'five-set-icon-lock'
			)
		),
		'six_set_v2'           => array(
			'name'  => 'Content Locking Shortcode Set 006',
			'css'   => 'six_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic',
				'//fonts.googleapis.com/css?family=PT+Serif'
			),
			'icons' => array(
				'six-set-icon-lock'
			)
		),
		'seven_set_v3'         => array(
			'name'  => 'Content Locking Shortcode Set 007 v1',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			),
			'icons' => array(
				'seven-set-icon-lock'
			)
		),
		'seven_set_v4'         => array(
			'name'  => 'Content Locking Shortcode Set 007 v2',
			'css'   => 'seven_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:400,700,300,900,300italic'
			),
			'icons' => array(
				'seven-set-icon-lock'
			)
		),
		'eight_set_v2'         => array(
			'name'  => 'Content Locking Shortcode Set 008',
			'css'   => 'eight_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:400'
			),
			'icons' => array(
				'eight-set-icon-lock'
			)
		),
		'nine_set_vms_step1'   => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 009',
			'css'        => 'nine_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
				'//fonts.googleapis.com/css?family=Lato:300,400'
			)
		),
		'nine_set_vms_step2'   => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 009',
			'css'        => 'nine_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			)
		),
		'ten_set_vms_step1'    => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 010',
			'css'        => 'ten_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600'
			)
		),
		'ten_set_vms_step2'    => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 010',
			'css'        => 'ten_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600',
				'//fonts.googleapis.com/css?family=Roboto:300',
			),
			'icons'      => array(
				'ten-set-mail'
			)
		),
		'eleven_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 011',
			'css'        => 'eleven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
			'icons'      => array(
				'eleven-set-icon-beginner',
				'eleven-set-icon-advanced'
			),
		),
		'eleven_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 011',
			'css'        => 'eleven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
		),
		'eleven_set_vms_step3' => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 011',
			'css'        => 'eleven_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			),
		),
		'twelve_set_vms_step1' => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step2' => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step3' => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'twelve_set_vms_step4' => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 012',
			'css'        => 'twelve_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'20_set'               => array(
			'name'  => 'Shortcode Set 020',
			'css'   => '20_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'21_set'               => array(
			'name'  => 'Shortcode Set 021',
			'css'   => '21_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-21-icon-mail'
			)
		),
		'22_set'               => array(
			'name'  => 'Shortcode Set 022',
			'css'   => '22_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'23_set'               => array(
			'name'  => 'Shortcode Set 023',
			'css'   => '23_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'24_set'               => array(
			'name'  => 'Shortcode Set 024',
			'css'   => '24_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'25_set'               => array(
			'name'  => 'Shortcode Set 025',
			'css'   => '25_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'26_set'               => array(
			'name'  => 'Shortcode Set 026',
			'css'   => '26_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600',
			),
		),
		'27_set'               => array(
			'name'  => 'Shortcode Set 027',
			'css'   => '27_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
		),
		'28_set'               => array(
			'name'  => 'Shortcode Set 028',
			'css'   => '28_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'29_set'               => array(
			'name'  => 'Shortcode Set 029',
			'css'   => '29_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
			),
			'icons' => array(
				'set-29-icon-mail'
			)
		),
		'30_set'               => array(
			'name'  => 'Shortcode Set 030',
			'css'   => '30_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'31_set'               => array(
			'name'  => 'Shortcode Set 031',
			'css'   => '31_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'32_set'               => array(
			'name'  => 'Shortcode Set 032',
			'css'   => '32_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600',
			),
		),
		'33_set'               => array(
			'name'  => 'Shortcode Set 033',
			'css'   => '33_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'34_set'               => array(
			'name'  => 'Shortcode Set 034',
			'css'   => '34_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'35_set'               => array(
			'name'  => 'Shortcode Set 035',
			'css'   => '35_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'36_set'               => array(
			'name'  => 'Shortcode Set 036',
			'css'   => '36_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700'
			),
		),
		'37_set'               => array(
			'name'  => 'Shortcode Set 037',
			'css'   => '37_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700'
			),
		),
		'38_set'               => array(
			'name'  => 'Shortcode Set 038',
			'css'   => '38_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700,700italic,500italic'
			),
		),
		'39_set'               => array(
			'name'  => 'Shortcode Set 039',
			'css'   => '39_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
			),
		),
		'40_set'               => array(
			'name'  => 'Shortcode Set 040',
			'css'   => '40_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'41_set'               => array(
			'name'  => 'Shortcode Set 041',
			'css'   => '41_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'42_set'               => array(
			'name'  => 'Shortcode Set 042',
			'css'   => '42_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700',
				'//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,700,600'
			),
		),
		'43_set'               => array(
			'name'  => 'Shortcode Set 043',
			'css'   => '43_set.css',
			'fonts' => array(
				'//fonts.googleapis.com/css?family=Roboto:400,300,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			),
		),
		'44_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'44_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 044',
			'css'        => '44_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'45_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 045',
			'css'        => '45_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'46_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 046',
			'css'        => '46_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'46_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 046',
			'css'        => '46_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'47_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'47_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 047',
			'css'        => '47_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Comfortaa:400,700,300'
			)
		),
		'48_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'48_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 048',
			'css'        => '48_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Lato:300,400,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'49_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 049',
			'css'        => '49_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Dosis:400,600,300',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'50_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'50_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 050',
			'css'        => '50_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,700,300',
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'51_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 051',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'51_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 051',
			'css'        => '51_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Cabin:400,500,700',
				'//fonts.googleapis.com/css?family=Roboto+Slab:400,300,700'
			)
		),
		'52_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			),
			'icons'      => array(
				'set-52-icon'
			)
		),
		'52_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 052',
			'css'        => '52_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700'
			)
		),
		'53_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 053',
			'css'        => '53_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'53_set_vms_step2'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 053',
			'css'        => '53_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Open+Sans:400,300,700',
				'//fonts.googleapis.com/css?family=Lato:300,400,700'
			)
		),
		'54_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 054',
			'css'        => '54_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,100,300,500,700'
			),
			'icons'      => array(
				'set-54-book'
			)
		),
		'55_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 055',
			'css'        => '55_set.css',
			'icons'      => array(
				'set-55-download'
			)
		),
		'56_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 056',
			'css'        => '56_set.css',
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Roboto:400,100,300,500,700',
				'//fonts.googleapis.com/css?family=Raleway:700,400'
			),
			'icons'      => array(
				'set-56-book'
			)
		),
		'57_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 057',
			'css'        => '57_set.css',
			'icons'      => array(
				'set-57-hand'
			)
		),
		'58_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 058',
			'css'        => '58_set.css',
			'icons'      => array(
				'set-58-arrow'
			),
			'fonts'      => array(
				'//fonts.googleapis.com/css?family=Quicksand:400,300,700'
			)
		),
		'59_set_vms_step1'     => array(
			'multi_step' => true,
			'name'       => 'Shortcode Set 059',
			'css'        => '59_set.css',
			'icons'      => array(
				'set-59-download'
			)
		),
	),
	'multi_step'    => array(
		'shortcode'     => array(
			'nine_set'   => array(
				'name'   => 'Shortcode multi-step set 009',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|nine_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|nine_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			/*'ten_set' => array(
                'name' => 'Shortcode multi-step set 010',
                'states' => array(
                    1 => array(
                        'tpl' => 'shortcode|ten_set_vms_step1',
                        'state' => 'default', // or already_subscribed
                    ),
                    2 => array(
                        'tpl' => 'shortcode|ten_set_vms_step2',
                        'state' => 'default', // or already_subscribed
                    ),
                )
            ),*/
			'eleven_set' => array(
				'name'   => 'Shortcode multi-step set 011',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|eleven_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|eleven_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
					3 => array(
						'tpl'   => 'shortcode|eleven_set_vms_step3',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'twelve_set' => array(
				'name'   => 'Shortcode multi-step set 012',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|twelve_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|twelve_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
					3 => array(
						'tpl'   => 'shortcode|twelve_set_vms_step3',
						'state' => 'default', // or already_subscribed
					),
					4 => array(
						'tpl'   => 'shortcode|twelve_set_vms_step4',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'44_set'     => array(
				'name'   => 'Shortcode multi-step set 044',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|44_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|44_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'45_set'     => array(
				'name'   => 'Shortcode multi-step set 045',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|45_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|45_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'46_set'     => array(
				'name'   => 'Shortcode multi-step set 046',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|46_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|46_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'47_set'     => array(
				'name'   => 'Shortcode multi-step set 047',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|47_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|47_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'48_set'     => array(
				'name'   => 'Shortcode multi-step set 048',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|48_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|48_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'49_set'     => array(
				'name'   => 'Shortcode multi-step set 049',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|49_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|49_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'50_set'     => array(
				'name'   => 'Shortcode multi-step set 050',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|50_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|50_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'51_set'     => array(
				'name'   => 'Shortcode multi-step set 051',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|51_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|51_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'52_set'     => array(
				'name'   => 'Shortcode multi-step set 052',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|52_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|52_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'53_set'     => array(
				'name'   => 'Shortcode multi-step set 053',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|53_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'shortcode|53_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'54_set'     => array(
				'name'   => 'Shortcode multi-step set 054',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|54_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|54_set_vms_step2',
						'state' => 'lightbox', // or already_subscribed
					),
				)
			),
			'55_set'     => array(
				'name'   => 'Shortcode multi-step set 055',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|55_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|55_set_vms_step2',
						'state' => 'lightbox', // or already_subscribed
					),
				)
			),
			'56_set'     => array(
				'name'   => 'Shortcode multi-step set 056',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|56_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|56_set_vms_step2',
						'state' => 'lightbox', // or already_subscribed
					),
				)
			),
			'57_set'     => array(
				'name'   => 'Shortcode multi-step set 057',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|57_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|57_set_vms_step2',
						'state' => 'lightbox', // or already_subscribed
					),
				)
			),
			'58_set'     => array(
				'name'   => 'Shortcode multi-step set 058',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|58_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|58_set_vms_step2',
						'state' => 'lightbox', // or already_subscribed
					),
				)
			),
			'59_set'     => array(
				'name'   => 'Shortcode multi-step set 059',
				'states' => array(
					1 => array(
						'tpl'   => 'shortcode|59_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|59_set_vms_step2',
						'state' => 'lightbox', // or already_subscribed
					),
				)
			)
		),
		'post_footer'   => array(
			'nine_set'   => array(
				'name'   => 'Post Footer multi-step set 009',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|nine_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|nine_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			/*'ten_set' => array(
                'name' => 'Post Footer multi-step set 010',
                'states' => array(
                    1 => array(
                        'tpl' => 'post_footer|ten_set_vms_step1',
                        'state' => 'default', // or already_subscribed
                    ),
                    2 => array(
                        'tpl' => 'post_footer|ten_set_vms_step2',
                        'state' => 'default', // or already_subscribed
                    ),
                )
            ),*/
			'eleven_set' => array(
				'name'   => 'Post Footer multi-step set 011',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|eleven_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|eleven_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
					3 => array(
						'tpl'   => 'post_footer|eleven_set_vms_step3',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'twelve_set' => array(
				'name'   => 'Post Footer multi-step set 012',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|twelve_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|twelve_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
					3 => array(
						'tpl'   => 'post_footer|twelve_set_vms_step3',
						'state' => 'default', // or already_subscribed
					),
					4 => array(
						'tpl'   => 'post_footer|twelve_set_vms_step4',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'44_set'     => array(
				'name'   => 'Post Footer multi-step set 044',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|44_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|44_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'45_set'     => array(
				'name'   => 'Post Footer multi-step set 045',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|45_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|45_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'46_set'     => array(
				'name'   => 'Post Footer multi-step set 046',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|46_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|46_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'47_set'     => array(
				'name'   => 'Post Footer multi-step set 047',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|47_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|47_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'48_set'     => array(
				'name'   => 'Post Footer multi-step set 048',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|48_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|48_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'49_set'     => array(
				'name'   => 'Post Footer multi-step set 049',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|49_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|49_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'50_set'     => array(
				'name'   => 'Post Footer multi-step set 050',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|50_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|50_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'51_set'     => array(
				'name'   => 'Post Footer multi-step set 051',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|51_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|51_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'52_set'     => array(
				'name'   => 'Post Footer multi-step set 052',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|52_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|52_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'53_set'     => array(
				'name'   => 'Post Footer multi-step set 053',
				'states' => array(
					1 => array(
						'tpl'   => 'post_footer|53_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'post_footer|53_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
		),
		'lightbox'      => array(
			'one_set'    => array(
				'name'   => 'Lightbox multi-step set 001',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|one_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|one_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'two_set'    => array(
				'name'   => 'Lightbox multi-step set 002',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|two_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|two_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'eight_set'  => array(
				'name'   => 'Lightbox multi-step set 008',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|eight_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|eight_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'nine_set'   => array(
				'name'   => 'Lightbox multi-step set 009',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|nine_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|nine_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'ten_set'    => array(
				'name'   => 'Lightbox multi-step set 010',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|ten_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|ten_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'eleven_set' => array(
				'name'   => 'Lightbox multi-step set 011',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|eleven_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|eleven_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
					3 => array(
						'tpl'   => 'lightbox|eleven_set_vms_step3',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'twelve_set' => array(
				'name'   => 'Lightbox multi-step set 012',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|twelve_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|twelve_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
					3 => array(
						'tpl'   => 'lightbox|twelve_set_vms_step3',
						'state' => 'default', // or already_subscribed
					),
					4 => array(
						'tpl'   => 'lightbox|twelve_set_vms_step4',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'44_set'     => array(
				'name'   => 'Lightbox multi-step set 044',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|44_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|44_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'45_set'     => array(
				'name'   => 'Lightbox multi-step set 045',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|45_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|45_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'46_set'     => array(
				'name'   => 'Lightbox multi-step set 046',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|46_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|46_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'47_set'     => array(
				'name'   => 'Lightbox multi-step set 047',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|47_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|47_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'48_set'     => array(
				'name'   => 'Lightbox multi-step set 048',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|48_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|48_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'49_set'     => array(
				'name'   => 'Lightbox multi-step set 049',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|49_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|49_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'50_set'     => array(
				'name'   => 'Lightbox multi-step set 050',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|50_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|50_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'51_set'     => array(
				'name'   => 'Lightbox multi-step set 051',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|51_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|51_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'52_set'     => array(
				'name'   => 'Lightbox multi-step set 052',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|52_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|52_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'53_set'     => array(
				'name'   => 'Lightbox multi-step set 053',
				'states' => array(
					1 => array(
						'tpl'   => 'lightbox|53_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'lightbox|53_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
		),
		'screen_filler' => array(
			'thirteen_set' => array(
				'name'   => 'Screen Filler multi-step set 013',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|thirteen_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|thirteen_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'fourteen_set' => array(
				'name'   => 'Screen Filler multi-step set 014',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|fourteen_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|fourteen_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'fifteen_set'  => array(
				'name'   => 'Screen Filler multi-step set 015',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|fifteen_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|fifteen_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
					3 => array(
						'tpl'   => 'screen_filler|fifteen_set_vms_step3',
						'state' => 'default', // or already_subscribed
					),
					4 => array(
						'tpl'   => 'screen_filler|fifteen_set_vms_step4',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'eighteen_set' => array(
				'name'   => 'Screen Filler multi-step set 018',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|eighteen_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|eighteen_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'44_set'       => array(
				'name'   => 'Screen Filler multi-step set 044',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|44_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|44_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'45_set'       => array(
				'name'   => 'Screen Filler multi-step set 045',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|45_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|45_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'46_set'       => array(
				'name'   => 'Screen Filler multi-step set 046',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|46_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|46_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'47_set'       => array(
				'name'   => 'Screen Filler multi-step set 047',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|47_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|47_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'48_set'       => array(
				'name'   => 'Screen Filler multi-step set 048',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|48_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|48_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'49_set'       => array(
				'name'   => 'Screen Filler multi-step set 049',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|49_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|49_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'50_set'       => array(
				'name'   => 'Screen Filler multi-step set 050',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|50_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|50_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'51_set'       => array(
				'name'   => 'Screen Filler multi-step set 051',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|51_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|51_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'52_set'       => array(
				'name'   => 'Screen Filler multi-step set 052',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|52_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|52_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'53_set'       => array(
				'name'   => 'Screen Filler multi-step set 053',
				'states' => array(
					1 => array(
						'tpl'   => 'screen_filler|53_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'screen_filler|53_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			)
		),
		'greedy_ribbon' => array(
			'gr_four_set'    => array(
				'name'   => 'Scroll Mat multi-step set 004 v1',
				'states' => array(
					1 => array(
						'tpl'   => 'greedy_ribbon|gr_four_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'greedy_ribbon|gr_four_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'gr_four_set_v2' => array(
				'name'   => 'Scroll Mat multi-step set 004 v2',
				'states' => array(
					1 => array(
						'tpl'   => 'greedy_ribbon|gr_four_set_vms_step1_v2',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'greedy_ribbon|gr_four_set_vms_step2_v2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'gr_five_set'    => array(
				'name'   => 'Scroll Mat multi-step set 005',
				'states' => array(
					1 => array(
						'tpl'   => 'greedy_ribbon|gr_five_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'greedy_ribbon|gr_five_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'gr_six_set'     => array(
				'name'   => 'Scroll Mat multi-step set 006',
				'states' => array(
					1 => array(
						'tpl'   => 'greedy_ribbon|gr_six_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'greedy_ribbon|gr_six_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'gr_seven_set'   => array(
				'name'   => 'Scroll Mat multi-step set 007',
				'states' => array(
					1 => array(
						'tpl'   => 'greedy_ribbon|gr_seven_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'greedy_ribbon|gr_seven_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			),
			'gr_eight_set'   => array(
				'name'   => 'Scroll Mat multi-step set 008',
				'states' => array(
					1 => array(
						'tpl'   => 'greedy_ribbon|gr_eight_set_vms_step1',
						'state' => 'default', // or already_subscribed
					),
					2 => array(
						'tpl'   => 'greedy_ribbon|gr_eight_set_vms_step2',
						'state' => 'default', // or already_subscribed
					),
				)
			)
		)
	)
);

