<?php
/*
Plugin Name: ProjectTheme Radius Search
Plugin URI: http://sitemile.com/
Description: Adds a radius search feature to the advanced search in ProjectTheme.
Author: SiteMile.com
Author URI: http://sitemile.com/
Version: 1.6
Text Domain: ProjectTheme_radius
*/

//--------------------------------------------------

add_filter('ProjectTheme_execute_on_submit_1','ProjectTheme_execute_on_submit_1_rad',10, 2);
add_filter('ProjectTheme_adv_search_before_search','ProjectTheme_adv_search_before_search_rads');
add_filter('ProjectTheme_adv_search_add_to_form','ProjectTheme_adv_search_add_to_form_radius');

//************************************************
add_action('plugins_loaded', 'PR_wan_load_textdomain');
function PR_wan_load_textdomain() {
	load_plugin_textdomain( 'ProjectTheme_radius', false, dirname( plugin_basename(__FILE__) ) . '/lang/' );
}

function ProjectTheme_adv_search_add_to_form_radius()
{
	?>

    <li><h2><?php _e('Zip Code',"ProjectTheme_radius"); ?>:</h2><p>
                   <input class="form-control" size="10" value="<?php echo $_GET['zip_code']; ?>" name="zip_code" /></p></li>

    <li><h2><?php _e('Radius',"ProjectTheme_radius"); ?>: </h2><p>
                   <input class="form-control" size="10" value="<?php echo $_GET['radius']; ?>" name="radius" placeholder="<?php _e('miles',"ProjectTheme_radius"); ?>" />
                    </p></li>

    <?php
}

function ProjectTheme_adv_search_before_search_rads()
{
	if(!empty($_GET['zip_code']))
	{
		global $local_long, $local_lat, $radius ;

		$country = ''; //"UK";
		$zip 	= trim($_GET['zip_code']);
		$radius = trim($_GET['radius']);

		if(empty($radius)) $radius = 10;

		global $mak_address;

		$mak_address = $country.",".$zip;

		$data 	= ProjectTheme_radius_get_geo_coordinates($country.",".$zip);
		$local_long 	= $data->lng;
		$local_lat 		= $data->lat;

		add_filter('posts_join', 'ProjectTheme_radius_get_lat_stuff_join' );
		add_filter('posts_join', 'ProjectTheme_radius_get_long_stuff_join' );
		add_filter('posts_where', 'ProjectTheme_radius_adv_search_where_thing');


	}

}

function ProjectTheme_radius_adv_search_where_thing($where)
{
			global $local_long, $local_lat, $radius ;
			global $wpdb;

			$where .= " AND

			((ACOS(SIN($local_lat * PI() / 180) * SIN(`project_lat` * PI() / 180) + COS($local_lat * PI() / 180) * COS(`project_lat` * PI() / 180) *
			COS(($local_long - `project_long`) * PI() / 180)) * 180 / PI()) * 60 * 1.1515)

			< '$radius'";

		return $where;
}


function ProjectTheme_radius_get_lat_stuff_join($wp_join)
{

			global $wpdb;
			$wp_join .= " LEFT JOIN (
					SELECT post_id, meta_value as project_lat
					FROM $wpdb->postmeta
					WHERE meta_key =  'project_lat' ) AS DD1
					ON $wpdb->posts.ID = DD1.post_id ";

		return ($wp_join);
}


function ProjectTheme_radius_get_long_stuff_join($wp_join)
{
			global $wpdb;
			$wp_join .= " LEFT JOIN (
					SELECT post_id, meta_value as project_long
					FROM $wpdb->postmeta
					WHERE meta_key =  'project_long' ) AS DD2
					ON $wpdb->posts.ID = DD2.post_id ";

		return ($wp_join);
}

function ProjectTheme_execute_on_submit_1_rad($pid, $key = '')
{

	$zip =  get_post_meta($pid, "Location", true);


	$loc 		= wp_get_post_terms( $pid, 'project_location');
	$loc_a 	= '';

	foreach($loc as $l)
		$loc_a .= $l->name.',' ;

	$loc_a .= $zip;

	//$data = ProjectTheme_radius_get_geo_coordinates($loc_a, $key);
	//$long = $data->lng;
	//$lat 	= $data->lat;

	update_post_meta($pid, 'project_lat', 	$_POST['project_lat']);
	update_post_meta($pid, 'project_long', 	$_POST['project_lon']);
}

//************************************************

add_filter('projecttheme_above_advanced_search_page','projecttheme_above_advanced_search_page_rds');

function projecttheme_above_advanced_search_page_rds($the_query)
{

	$my_arr = array();
	$radius = $_GET['radius'];

	if($the_query->have_posts()):
		while ( $the_query->have_posts() ) : $the_query->the_post();

			 $ar_itm['lat'] = get_post_meta(get_the_ID(),'project_lat',true);
			 $ar_itm['long'] = get_post_meta(get_the_ID(),'project_long',true);
			  $ar_itm['ttl'] = get_the_title();
			  $ar_itm['lnk'] = get_the_permalink();

				$my_arr[] = $ar_itm;

		endwhile; endif;


	?>

		<div class="row mb-3"><div class=" col-xs-12 col-sm-4 col-md-12 col-lg-12 p-0"><div class="card" style="width:100%;"><div class="card-header">
                    <h3 class="card-title"><?php _e('Map Results','ProjectTheme') ?></h3>
                  </div>

									<div class="card-body p-0">



			<div id="map" style="height: 300px;"></div>
			<script type="text/javascript" src="https://maps.google.com/maps/api/js?sensor=false&key=<?php echo get_option('ProjectTheme_radius_maps_api_key') ?>"></script>

			    <script>

 var myLatlng = new google.maps.LatLng(1,1);
  var myOptions = {
    zoom: 11,
    center: myLatlng,
    mapTypeId: google.maps.MapTypeId.ROADMAP
  }
  var map = new google.maps.Map(document.getElementById("map"), myOptions);
	var bounds = new google.maps.LatLngBounds();



		<?php

	foreach($my_arr as $item):

		if(!empty($item['lat']) and !empty($item['long']))
		{

	?>

  var Marker = new google.maps.Marker({
      position: new google.maps.LatLng(<?php echo $item['lat']; ?>,<?php echo $item['long']; ?>),
      map: map,
      title:"<?php echo $item['ttl']; ?>"
  });

  google.maps.event.addListener(Marker, 'click', function() {
    window.location = '<?php echo $item['lnk']; ?>';
  });

  var ll = new google.maps.LatLng(<?php echo $item['lat']; ?>,
        <?php echo $item['long']; ?>);
    bounds.extend(ll);


<?php }  endforeach; ?>


map.fitBounds(bounds);
</script>

	</div></div></div>


	<?php

}


function ProjectTheme_radius_get_geo_coordinates($addr, $key = '')
{

	if(empty($addr)) return '';

	//http://maps.google.com/maps/geo?output=csv&q=Bucharest&key=

	$key = get_option('ProjectTheme_radius_maps_api_key');
	$url = 'https://maps.googleapis.com/maps/api/geocode/json?address='.urlencode($addr).'&sensor=false&key=' . $key;


	$data = ProjectTheme_radius_curl_get_data($url);

	$data = json_decode($data); //explode(",", $data);


	if($data->status != "OK"){ echo ("Your google key is not correct or is not enabled for geocoding api");

echo '<br/><br/>';				print_r($data);
				exit;
	}

	//print_r($data);

	return $data->results[0]->geometry->location;
}

//************************************************

function ProjectTheme_radius_curl_get_data($url)
{
	  $ch = curl_init();
	  $timeout = 5;
	  curl_setopt($ch,CURLOPT_URL,$url);
	  curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
	  curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);
	  $data = curl_exec($ch);
	  curl_close($ch);
	  return $data;
}

?>
