

<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8" />
	<link rel="icon" type="image/png" href="../assets/img/favicon.ico">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />

	<title>SellerStats</title>

	<meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0' name='viewport' />
    <meta name="viewport" content="width=device-width" />


    <!-- Bootstrap core CSS     -->
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet" />

    <!--  Light Bootstrap Dashboard core CSS    -->
    <link href="../assets/css/light-bootstrap-dashboard.css" rel="stylesheet"/>


    <!--     Fonts and icons     -->
    <link href="../assets/css/font-awesome.min.css" rel="stylesheet">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,700,300' rel='stylesheet' type='text/css'>
    <link href="../assets/css/pe-icon-7-stroke.css" rel="stylesheet" />

	<link href="lib/noty.css" rel="stylesheet">
	<script src="lib/noty.min.js" type="text/javascript"></script>
	<script>
		Noty.overrideDefaults({
			layout   : 'topRight',
			theme    : 'relax',
			timeout: 2000,
			closeWith: ['click', 'button']
		});
	</script>	
	

</head>
<body>

<div class="wrapper">
    <div class="sidebar" data-color="black" data-image="../assets/img/sidebar-img.jpg">


        <div class="logo">
            <a href="#" class="logo-text">
                SellerStats
            </a>
        </div>
		<div class="logo logo-mini">
			<a href="#" class="logo-text">
				SS
			</a>
		</div>

    	<div class="sidebar-wrapper">

			<ul class="nav">
                <li>
                    <a href="dashboard.php">
                        <i class="pe-7s-note2"></i>
                        <p>Switch Accounts</p>
                    </a>
                </li>
                <li class="active">
                    <a href="account.php">
                        <i class="pe-7s-tools"></i>
                        <p>Tools</p>
                    </a>
                </li>
				<li>
                    <a href="settings.php">
                        <i class="pe-7s-settings"></i>
                        <p>Settings</p>
                    </a>
                </li>
				<li>
                    <a href="help.php">
                        <i class="pe-7s-help2"></i>
                        <p>Help</p>
                    </a>
                </li>
                
            </ul>
            
    	</div>
    </div>

    <div class="main-panel">
		<nav class="navbar navbar-default">
			<div class="container-fluid">
				<div class="navbar-minimize">
					<button id="minimizeSidebar" class="btn btn-black btn-fill btn-round btn-icon">
						<i class="fa fa-ellipsis-v visible-on-sidebar-regular"></i>
						<i class="fa fa-navicon visible-on-sidebar-mini"></i>
					</button>
				</div>
				<div class="navbar-header">
					<button type="button" class="navbar-toggle" data-toggle="collapse">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					<a class="navbar-brand" href="account.php">US Seller Account</a>
				</div>
								<div class="collapse navbar-collapse">
					<ul class="nav navbar-nav navbar-right">

						<li class="dropdown dropdown-with-icons">
							<a href="#" class="dropdown-toggle" data-toggle="dropdown">
								<i class="fa fa-list"></i>
								<p class="hidden-md hidden-lg">
									More
									<b class="caret"></b>
								</p>
							</a>
							<ul class="dropdown-menu dropdown-with-icons">
								<li>
									<a href="reset.php">
										<i class="pe-7s-lock"></i> Change Password
									</a>
								</li>
								<li>
									<a href="logout.php" class="text-danger">
										<i class="pe-7s-close-circle"></i>
										Log Out
									</a>
								</li>
							</ul>
						</li>

					</ul>
				</div>
			</div>
		</nav>

        <div class="content">
            <div class="container-fluid">
						
				<div class="row">
				
													
				<form action="hs.php" method="POST">	
					<div class="col-md-4">
					    <div class="card">
                            <div class="header" style="margin-bottom:15px;">
								<div class="pull-left">
									<h4 style="display:inline;" class="title">Shipment Main Settings</h4>
								</div>
                            </div>
                            <div class="content" style="padding-left:20px;margin-top:30px;">
							
								
									<fieldset>
										<div class="form-group col-md-12">
											<label for="name">Shipment Name</label>
											<input pattern=".{5,}" title="The name should have at least 5 characters" type="text" class="form-control" id="name" name="name" placeholder="This name will appear in Seller Central" required>
										</div>
									</fieldset>									
									<fieldset>
										<div class="form-group col-md-12">
											<label for="marketplace">Who labels the items?</label>
											<select class="form-control" id="label" name="label">
												<option value="SELLER_LABEL" selected>Seller</option>
												<option value="AMAZON_LABEL_ONLY" >Amazon</option>
											</select>
										</div>
									</fieldset>		

								<fieldset id="hackshipment">
									<div class="text-center col-md-12 mt10 mb20">
										<button type="submit" class="btn btn-block btn-large btn-success" disabled>Hack Shipment</button>
									</div> 
								</fieldset>											
									
							
							</div>
                        </div>
					</div>	

					
					
					<div class="col-md-4">
					    <div class="card">
                            <div class="header" style="margin-bottom:15px;">
								<div class="pull-left">
									<h4 style="display:inline;" class="title">Ship From Address</h4>
								</div>
                            </div>
                            <div class="content" style="padding-left:20px;margin-top:30px;">
							
												<fieldset>
										<div class="form-group col-md-12">
											<label for="name">Full Name</label>
											<input pattern=".{5,}" title="The name should have at least 5 characters" type="text" class="form-control" id="address_name" name="address_name" placeholder="John Doe" required>
										</div>
									</fieldset>	
									<fieldset>
										<div class="form-group col-md-12">
											<label for="address_line1">Address Line 1</label>
											<input pattern=".{5,}" title="The address should have at least 5 characters" type="text" class="form-control" id="address_line1" name="address_line1" placeholder="43 Main Ave." required>
										</div>
									</fieldset>	
									<fieldset>
										<div class="form-group col-md-12">
											<label for="address_line2">Address Line 2</label>
											<input type="text" class="form-control" id="address_line2" name="address_line2" placeholder="optional">
										</div>
									</fieldset>	
									<fieldset>
										<div class="form-group col-md-12">
											<label for="city">City</label>
											<input type="text" class="form-control" id="city" name="city" placeholder="Las Vegas" required>
										</div>
									</fieldset>	
									<fieldset>
										<div class="form-group col-md-12">
											<label for="state">State</label>
											<input type="text" class="form-control" id="state" name="state" placeholder="NV" required>
										</div>
									</fieldset>
									<fieldset>
										<div class="form-group col-md-12">
											<label for="zip">Postal Code</label>
											<input type="text" class="form-control" id="zip" name="zip" placeholder="88901" required>
										</div>
									</fieldset>
									<fieldset>
										<div class="form-group col-md-12">
											<label for="state">Country Code</label>
											<input  pattern=".{2,2}" title="the country code has exactly 2 characters" type="text" class="form-control" id="country" name="country" placeholder="US" required>
										</div>
									</fieldset>										


					
							
							</div>
                        </div>
					</div>	




					<div class="col-md-4" id="item-holder">	
						
						<fieldset id="additem"style="margin-top:20px;">
							<div class="text-center col-md-12 mt10 mb20">
								<button type="button" class="btn btn-block btn-large btn-warning" id="add-item"><span class="glyphicon glyphicon-plus"></span> Add Item</button>
							</div> 
						</fieldset>				
					
					</div>						
					
					
					
					


				<input type="hidden" name="item_ids" id="item_ids">
					
				</form>

				
				</div>
				
			</div>
		</div>




    </div>
</div>



    <!--   Core JS Files and PerfectScrollbar library inside jquery.ui   -->
    <script src="../assets/js/jquery.min.js" type="text/javascript"></script>
    <script src="../assets/js/jquery-ui.min.js" type="text/javascript"></script>
	<script src="../assets/js/bootstrap.min.js" type="text/javascript"></script>

	<script>
	Array.prototype.indexOf || (Array.prototype.indexOf = function(d, e) {
	var a;
	if (null == this) throw new TypeError('"this" is null or not defined');
	var c = Object(this),
	b = c.length >>> 0;
	if (0 === b) return -1;
	a = +e || 0;
	Infinity === Math.abs(a) && (a = 0);
	if (a >= b) return -1;
	for (a = Math.max(0 <= a ? a : b - Math.abs(a), 0); a < b;) {
	if (a in c && c[a] === d) return a;
	a++
	}
	return -1
	});
	</script>

	<!--  Forms Validations Plugin -->
	<script src="../assets/js/jquery.validate.min.js"></script>

	<!--  Plugin for Date Time Picker and Full Calendar Plugin-->
	<script src="../assets/js/moment.min.js"></script>

    <!--  Date Time Picker Plugin is included in this js file -->
    <script src="../assets/js/bootstrap-datetimepicker.js"></script>

    <!--  Select Picker Plugin -->
    <script src="../assets/js/bootstrap-selectpicker.js"></script>

	<!--  Checkbox, Radio, Switch and Tags Input Plugins -->
	<script src="../assets/js/bootstrap-checkbox-radio-switch-tags.js"></script>

	<!--  Charts Plugin -->
	<script src="../assets/js/chartist.min.js"></script>

    <!--  Notifications Plugin    -->
    <script src="../assets/js/bootstrap-notify.js"></script>

    <!-- Sweet Alert 2 plugin -->
	<script src="../assets/js/sweetalert2.js"></script>

    <!-- Vector Map plugin -->
	<script src="../assets/js/jquery-jvectormap.js"></script>

	<!-- Wizard Plugin    -->
    <script src="../assets/js/jquery.bootstrap.wizard.min.js"></script>

    <!--  Bootstrap Table Plugin    -->
    <script src="../assets/js/bootstrap-table.js"></script>

	<!--  Plugin for DataTables.net  -->
    <script src="../assets/js/jquery.datatables.js"></script>


    <!--  Full Calendar Plugin    -->
    <script src="../assets/js/fullcalendar.min.js"></script>

    <!-- Light Bootstrap Dashboard Core javascript and methods -->
	<script src="../assets/js/light-bootstrap-dashboard.js"></script>

	
	<script>
	

	
	var n_items = 0;
	var item_ids = [];
	
	$(document).ready(function(){
		
		
		$(document).on("click",".remove-item",function(){
			var id = $(this).attr("data-id");
			$(".item-card[data-id="+id+"]").remove();
			var index = item_ids.indexOf(parseInt(id));
			console.log(id);
			console.log(index);
			if(index>-1)
				item_ids.splice(index,1);
			$("#item_ids").val(item_ids.join());
			if(item_ids.length>0)
				$(':input[type="submit"]').prop('disabled', false);
			else
				$(':input[type="submit"]').prop('disabled', true);
		});
		
		$(document).on("click","#add-item",function(){
			
			n_items++;
			var curid = n_items;
			item_ids.push(curid);
			$("#item_ids").val(item_ids.join());
			
			if(item_ids.length>0)
				$(':input[type="submit"]').prop('disabled', false);
			else
				$(':input[type="submit"]').prop('disabled', true);
			
			var newitem = "<div class=\"card item-card\" data-id=\""+curid+"\"><div class=\"header\" style=\"margin-bottom:15px;\"><div class=\"pull-left\"><h4 style=\"display:inline;\" class=\"title\">Item "+curid+"</h4></div>";
			newitem += "<div class=\"pull-right\"><button type=\"button\" class=\"btn btn-danger btn-xs remove-item\" data-id=\""+curid+"\"><span class=\"glyphicon glyphicon-remove\"></span></button></div></div>";
			newitem += "<div class=\"content\" style=\"padding-left:20px;margin-top:30px;\"><fieldset><div class=\"form-group col-md-12\"><label for=\"sku-"+curid+"\">SKU</label><input type=\"text\" class=\"form-control\" id=\"sku-"+curid+"\" name=\"sku-"+curid+"\" placeholder=\"SELLER-SKU\" required>";
			newitem += "</div></fieldset><fieldset><div class=\"form-group col-md-12\"><label for=\"nu-"+curid+"\">Number of units</label><input type=\"text\" class=\"form-control\" id=\"nu-"+curid+"\" name=\"nu-"+curid+"\" placeholder=\"1000\" required>";
            newitem += "</div></fieldset><fieldset><div class=\"form-group col-md-12\"><label for=\"prep-"+curid+"\">Who preps this item?</label><select class=\"form-control\" id=\"prep-"+curid+"\" name=\"prep-"+curid+"\">";                
			newitem += "<option value=\"SELLER\" selected>Seller</option><option value=\"AMAZON\" >Amazon</option></select></div></fieldset><fieldset><div class=\"form-group col-md-12\">";
			newitem += "<label for=\"preptype-"+curid+"\">Type of prep</label><select class=\"form-control\" id=\"preptype-"+curid+"\" name=\"preptype-"+curid+"\"><option value=\"Labeling\" selected>Labeling</option>";
			newitem += "<option value=\"Polybagging\" >Polybagging</option><option value=\"BubbleWrapping\" >BubbleWrapping</option><option value=\"Taping\" >Taping</option><option value=\"BlackShrinkWrapping\" >BlackShrinkWrapping</option>";					
			newitem += "<option value=\"HangGarment\" >HangGarment</option></select></div></fieldset></div></div>";	
			
			
			$("#item-holder").prepend(newitem);
		});
		
	});
	</script>


</body>
</html>