function check_email(public_key,email,order)
	{
	$.post(
		"https://sellerstats.com/cyfr2/api.php",
		{public_key: public_key, action: "check_email",email: email,order: order},
		function(data){
			if(data.error)
				alert(data.error);
			if(data.redirect)
				window.location.replace(data.redirect);
			},
		"json");
	}
	
function copyToClipboard(what)
	{
	var $temp = $("<input>");
	$("body").append($temp);
	$temp.val(what).select();
	document.execCommand("copy");
	$temp.remove();
	}
	
jQuery(document).ready(function($)
	{
	
	//on page 2, format order ID field via inputmask
	if($("#tmp_input-75450 > input").length)
		{
		$("#tmp_input-75450 > input").inputmask("999-9999999-9999999");	
		}
		
	//on page 9, format order ID field via inputmask
	if($("#tmp_input-61322 > input").length)
		{
		$("#tmp_input-61322 > input").inputmask("999-9999999-9999999");	
		}	
	
	
	//get campaign public key
	var public_key = $("script[src*='cyfr2.js']").attr('data-key'); 
	
	//page 1 (landing page) - collect email and name
	$("#tmp_button-82434 > a").click(function(event)
		{
		var name = $("#tmp_input-65301 > input").val();
		var email = $("#tmp_input-24801 > input").val();
		$.cookie("cyfr_email", email, { expires : 10, path: '/' });
		$.cookie("cyfr_name", name, { expires : 10, path: '/' });
		});
		
	//page 2 - collect order and check if order exists	
	$("#tmp_button-15246 > a").click(function(event)
		{
		var email = $.cookie('cyfr_email');
		var order = $("#tmp_input-75450 > input").val();
		$.cookie("cyfr_order", order, { expires : 10, path: '/' });
		$("#row--34150").hide();
		$("#row--72329").show();
		check_email(public_key,email,order);	
		});	
	
	//page 3 - survey step 1 - check how long the product was used for
	$("#tmp_button-51373 > a").click(function(event)
		{
		var time_used = $('input[name=time_used]:checked').val();
		if(time_used==1)
			{
			$.post(
				"https://sellerstats.com/cyfr2/api.php",
				{public_key: public_key, action: "survey_step_1", choice: "1"},
				function(data){
					if(data.redirect)
						window.location.replace(data.redirect);
					},
				"json");				
			}
		else if(time_used==2||time_used==3)
			{
			$.post(
				"https://sellerstats.com/cyfr2/api.php",
				{public_key: public_key, action: "survey_step_1", choice: "2"},
				function(data){
					if(data.redirect)
						window.location.replace(data.redirect);
					},
				"json");				
			}
		else
			{
			alert("Please answer the question first, thank you!");	
			}
		});
	
	//page 4 - survey step 2 - check review length
	if($("#review").length)
		{
		$("#review_textarea").on('keyup', function(event) {
			var currentString = $("#review_textarea").val();
			if (currentString.length <= 50)  
				{
				$("#tmp_subheadline-52137").css("color","#F00");
				$("#tmp_subheadline-52137").css("font-weight","bold");
				}
			else 
				{
				$("#tmp_subheadline-52137").css("color","#000");
				$("#tmp_subheadline-52137").css("font-weight","normal");
				}
			});
		}
		
	//page 4 - survey step 2 - collect review and rating
	$("#tmp_button-34572 > a").click(function()
		{
		var rating = $('input[name=rating_radio]:checked').val();
		var review = $("#review_textarea").val();
		var recommended = $('input[name=recommended_radio]:checked').val();
		var email = $.cookie("cyfr_email");
		var order = $.cookie("cyfr_order");
		if((rating!=1&&rating!=2&&rating!=3&&rating!=4&&rating!=5)||review.length<=50||(recommended!=1&&recommended!=2&&recommended!=3&&recommended!=4&&recommended!=5))
			alert("Please complete the full survey first, thank you!");
		else
			{
			$.cookie("cyfr_review", review, { expires : 10, path: '/' });
			$.post(
				"https://sellerstats.com/cyfr2/api.php",
				{public_key: public_key, action: "survey_step_2", review: review, rating: rating, recommended: recommended, email: email, order: order},
				function(data){
					if(data.redirect)
						window.location.replace(data.redirect);
					},
				"json");				
			}		
		});
		
	//page 5 - copy paste - get review from cookie
	if($("#review-holder").length)
		{
		var review = $.cookie("cyfr_review");
		if(review==null)
			review = "Sorry, review unavailable...";
		$("#review").html("\""+review+"\"");	
		}	
	
	//page 5 - copy paste - copy to clipboard
	$("#tmp_button-18017 > a").click(function()
		{		
		var review = $.cookie("cyfr_review");
		if(review==null)
			review = "Sorry, review unavailable...";
		copyToClipboard(review);
		$("#review").hide();
		$("#tmp_button-18017").hide();
		$("#gif-arrow").show();
		});	
		
	//page 6 - confirm address - get the address from the order ID
	if($("#address").length)
		{
		var email = $.cookie("cyfr_email");
		var order = $.cookie("cyfr_order");
		$.post(
			"https://sellerstats.com/cyfr2/api.php",
			{public_key: public_key, action: "get_address", email: email, order: order},
			function(data){
				if(data.address)
					$("#address").html(data.address);
				},
			"json");				
		}		
	
	//page 6 - confirm address - the address is correct
	$("#tmp_button-37075 > a").click(function()
		{
		var email = $.cookie("cyfr_email");
		var order = $.cookie("cyfr_order");
		$.post(
			"https://sellerstats.com/cyfr2/api.php",
			{public_key: public_key, action: "confirm_order", email: email, order: order},
			function(data){
				if(data.redirect)
					window.location.replace(data.redirect);
				},
			"json");	
		});	
		
	//page 7 - update address - populate the fields
	if($("#update_address").length)
		{
		var email = $.cookie("cyfr_email");
		var order = $.cookie("cyfr_order");
			$.post(
			"https://sellerstats.com/cyfr2/api.php",
			{public_key: public_key, action: "get_address_for_update", email: email, order: order},
			function(data){
				console.log(data.address);
				if(data.address.name)
					$("input[name=name]").val(data.address.name);
				if(data.address.address)
					$("input[name=address]").val(data.address.address);
				if(data.address.city)
					$("input[name=city]").val(data.address.city);
				if(data.address.state)
					$("input[name=state]").val(data.address.state);
				if(data.address.phone)
					$("input[name=phone]").val(data.address.phone);
				if(data.address.zip)
					$("input[name=zip]").val(data.address.zip);
				},
			"json");				
		}	
		
	//page 7 - update address - submit new address
	$("#tmp_button-52398 > a").click(function()
		{		
		var address = $("input[name=address]").val();
		var city = $("input[name=city]").val();
		var state = $("input[name=state]").val();
		var zip = $("input[name=zip]").val();
		var phone = $("input[name=phone]").val();
		var name = $("input[name=name]").val();
		var email = $.cookie("cyfr_email");
		var order = $.cookie("cyfr_order");
		
		if(address.length<5||city.length<2||state.length<2||phone.length<7||zip<5||name.length<7)
			{
			alert("Please provide the complete address for the courier");	
			}
		else
			{
			$.post(
			"https://sellerstats.com/cyfr2/api.php",
			{public_key: public_key, action: "update_address", email: email, address: address, city: city, state: state, zip: zip, phone: phone, name: name, order:order},
			function(data){
				if(data.redirect)
					window.location.replace(data.redirect);
				},
			"json");			
			}		
		});	
		
	//page 9 - order ID not found - resubmit order ID	
	$("#tmp_button-64064 > a").click(function(event)
		{
		var email = $.cookie('cyfr_email');
		var order = $("#tmp_input-61322 > input").val();
		$.cookie("cyfr_order", order, { expires : 10, path: '/' });
		$("#row--34150").hide();
		$("#row--83372").show();
		check_email(public_key,email,order);
		});	
	
	//page 11 - already requested - show previous request ID 	
	if($("#already_requested").length)
		{
		var email = $.cookie('cyfr_email');
		var order = $.cookie('cyfr_order');
		$.post(
			"https://sellerstats.com/cyfr2/api.php",
			{public_key: public_key, action: "already_requested", email: email, order:order},
			function(data){
				if(data.message)
					{
					if(data.message=="not found")
						$("#already_requested").html("If you believe this is an error, please use the link at the top of this page to contact us.");
					else
						$("#already_requested").html(data.message);
					}
					
				},
			"json");						
		}
		
	});